% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OwenQ.R
\name{OwenQ2}
\alias{OwenQ2}
\title{Second Owen Q-function}
\usage{
OwenQ2(nu, t, delta, R, algo = 2)
}
\arguments{
\item{nu}{integer greater than \eqn{1}, the number of degrees of freedom}

\item{t}{number, positive or negative, possibly infinite}

\item{delta}{vector of finite numbers, with the same length as \code{R}}

\item{R}{(lower bound of the integral) vector of finite positive numbers,
with the same length as \code{delta}}

\item{algo}{the algorirthm used, \code{1} or \code{2}}
}
\value{
A vector of numbers between \eqn{0} and \eqn{1}, the values of the integral
from \eqn{R} to \eqn{\infty}.
}
\description{
Evaluates the second Owen Q-function (integral from \eqn{R} to \eqn{\infty})
for an integer value of the degrees of freedom.
}
\note{
When the number of degrees of freedom is odd, the procedure resorts to
the Owen T-function (\code{\link{OwenT}}).
}
\examples{
# OwenQ1(nu, t, delta, R) + OwenQ2(nu, t, delta, R) equals pt(t, nu, delta):
OwenQ1(nu=5, t=3, delta=2, R=1) + OwenQ2(nu=5, t=3, delta=2, R=1)
pt(q=3, df=5, ncp=2)
}
\references{
Owen, D. B. (1965).
A special case of a bivariate noncentral t-distribution.
\emph{Biometrika} \bold{52}, 437-446.
}
