% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psbt.R
\name{psbt}
\alias{psbt}
\alias{psbt1}
\alias{psbt2}
\alias{psbt3}
\alias{psbt4}
\title{Owen distribution functions}
\usage{
psbt1(nu, t1, t2, delta1, delta2, algo = 2)

psbt2(nu, t1, t2, delta1, delta2, algo = 2)

psbt3(nu, t1, t2, delta1, delta2, algo = 2)

psbt4(nu, t1, t2, delta1, delta2, algo = 2)
}
\arguments{
\item{nu}{integer greater than \eqn{1}, the number of degrees of freedom;
infinite allowed}

\item{t1, t2}{two numbers, positive or negative, possibly infinite}

\item{delta1, delta2}{two vectors of possibly infinite numbers with the same length,
the noncentrality parameters}

\item{algo}{the algorithm used, \code{1} or \code{2}}
}
\value{
A vector of numbers between \eqn{0} and \eqn{1},
possibly containing some \code{NaN}.
}
\description{
Evaluates the Owen cumulative distribution function
for an integer number of degrees of freedom.
\itemize{
\item \code{psbt1} evaluates \ifelse{html}{\out{P(T<sub>1</sub> &le; t<sub>1</sub>, T<sub>2</sub> &le; t<sub>2</sub>)}}{\eqn{P(T_1\le t_1, T_2 \le t_2)}}
\item \code{psbt2} evaluates \ifelse{html}{\out{P(T<sub>1</sub> &le; t<sub>1</sub>, T<sub>2</sub> > t<sub>2</sub>)}}{\eqn{P(T_1\le t_1, T_2 > t_2)}}
\item \code{psbt3} evaluates \ifelse{html}{\out{P(T<sub>1</sub> > t<sub>1</sub>, T<sub>2</sub> > t<sub>2</sub>)}}{\eqn{P(T_1> t_1, T_2 > t_2)}}
\item \code{psbt4} evaluates \ifelse{html}{\out{P(T<sub>1</sub> > t<sub>1</sub>, T<sub>2</sub> &le; t<sub>2</sub>)}}{\eqn{P(T_1> t_1, T_2 \le t_2)}}
}
}
\note{
When the number of degrees of freedom is odd, the procedure resorts to
the Owen T-function (\code{\link{OwenT}}).
}
\examples{
nu=5; t1=1; t2=2; delta1=2; delta2=3
( p1 <- psbt1(nu, t1, t2, delta1, delta2) )
( p2 <- psbt2(nu, t1, t2, delta1, delta2) )
( p3 <- psbt3(nu, t1, t2, delta1, delta2) )
( p4 <- psbt4(nu, t1, t2, delta1, delta2) )
# the sum should be 1
p1+p2+p3+p4
}
\references{
Owen, D. B. (1965).
A special case of a bivariate noncentral t-distribution.
\emph{Biometrika} \bold{52}, 437-446.
}
\seealso{
It is better to use \code{\link{powen}} if \code{delta1>delta2}.
}
