% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naFilter.R
\name{naFilter}
\alias{naFilter}
\title{naFilter Function}
\usage{
naFilter(data_object, na_cutoff = 0.4)
}
\arguments{
\item{data_object}{Input \emph{PALMO} S4 object. It contains annotation
information and expression data from Bulk or single cell data.}

\item{na_cutoff}{Threshold to remove NAs. Range is 0-1 (Default 0.4 means >40\%
NAs are not allowed).}
}
\value{
PALMO object with filtered NAs
}
\description{
This function allows users to filter genes/features having expression NAs
with user-defined threshold.
}
\examples{
\dontrun{
palmo_obj <- naFilter(data_object=palmo_obj, na_cutoff=0.4)
}
}
\keyword{naFilter}
