% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeBinaries.R
\name{removeBinaries}
\alias{removeBinaries}
\title{Remove Binaries from a PAMpalSettings Object}
\usage{
removeBinaries(pps, index = NULL)
}
\arguments{
\item{pps}{a \linkS4class{PAMpalSettings} object to remove binaries from}

\item{index}{index indicating which binary folders to remove. Can be a vector
if you want to remove multiple folders. If missing user is prompted to
select a folder from a list, will only show up to the first 20. You can
easily remove all of the folders with a large index like \code{1:1000}}
}
\value{
the same \linkS4class{PAMpalSettings} object as pps, with the binary
  folders and files associated with those folders removed from the "binaries"
  slot.
}
\description{
Remove a binary folder and associated files from the "binaries"
  slot in a PAMpalSettings object.
}
\examples{

exPps <- new('PAMpalSettings')
exPps <- addBinaries(exPps, system.file('extdata', 'Binaries', package='PAMpal'))
removeBinaries(exPps,index = 1)
if(interactive()) removeBinaries(exPps)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
