% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeWignerData.R
\name{writeWignerData}
\alias{writeWignerData}
\title{Write Wigner Transform Data of Click Detections to Disk}
\usage{
writeWignerData(
  x,
  n = 256,
  t = 300,
  outDir = ".",
  mode = "nparray",
  progress = TRUE,
  ...
)
}
\arguments{
\item{x}{\linkS4class{AcousticStudy} object containing data to make Wigner data for}

\item{n}{number of frequency bins for Wigner transform (recommended power of 2)}

\item{t}{number of samples to use for the click clip passed to the transform}

\item{outDir}{directory to write data to}

\item{mode}{specifies the kind of output that will be created, currently only
supports creating NumPy arrays using the \code{reticulate} package, in future
will support image creation}

\item{progress}{logical flag to show progress bar}

\item{\dots}{optional arguments to pass}
}
\value{
A list with two items: \code{files} - a vector of file names
  for the Wigner data that were successfully created, any that were not
  able to be written will be \code{NA}, and \code{warnings}, a list with
  items containing event IDs that triggered any warnings
}
\description{
Create Wigner-Ville transform data of click clips from all
  detections and save them to disk. A CSV file will also be written that
  lists all UIDs contained in the output
}
\examples{

data(exStudy)
exStudy <- setSpecies(exStudy, method='pamguard')
\dontrun{
# not running because files are written to disk
wigFiles <- writeWignerData(exStudy, outDir = 'WigFolder')
}

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
