% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadMarCadAIS.R
\name{downloadMarCadAIS}
\alias{downloadMarCadAIS}
\title{Download AIS Data from Marine Cadastre}
\usage{
downloadMarCadAIS(x, outDir, overwrite = FALSE, unzip = TRUE, verbose = TRUE)
}
\arguments{
\item{x}{a dataframe with column \code{UTC} in POSIXct format}

\item{outDir}{directory to save the downloaded files}

\item{overwrite}{logical flag to overwrite existing data. Recommended
to be \code{FALSE} to avoid re-downloading large files unnecessarily}

\item{unzip}{logical flag to unzip downloaded files. Original downloads
from Marine Cadastre come as large .zip}

\item{verbose}{logical flag to print messages about download progress}
}
\value{
a vector of the paths to the downloaded .zip files, any days
that were unable to download will be \code{NA}
}
\description{
Downloads daily AIS files from \url{https://marinecadastre.gov/ais/}
covering the date range present in input data
}
\examples{
# note this example downloads a ~500MB file
\donttest{
gps <- data.frame(Latitude=c(33.2, 33.5,33.6),
                  Longitude=c(-118.1, -118.4, -119),
                  UTC=as.POSIXct(
                    c('2022-04-28 05:00:00',
                      '2022-04-28 10:00:00',
                      '2022-04-28 20:00:00'),
                    tz='UTC'))
tempDir <- tempdir()
marcadFiles <- downloadMarCadAIS(gps, outDir=tempDir)
}

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
