% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMTree.R
\name{PCMTreeMatrixNodesInSamePart}
\alias{PCMTreeMatrixNodesInSamePart}
\alias{PCMTreeMatrixNodesInSameRegime}
\title{Which couples from a given set of nodes in a tree belong to the same part?}
\usage{
PCMTreeMatrixNodesInSamePart(
  tree,
  nodes = seq_len(PCMTreeNumNodes(tree)),
  upperTriangle = TRUE,
  returnVector = TRUE
)

PCMTreeMatrixNodesInSameRegime(
  tree,
  nodes = seq_len(PCMTreeNumNodes(tree)),
  upperTriangle = TRUE,
  returnVector = TRUE
)
}
\arguments{
\item{tree}{a PCMTree object or a phylo object.}

\item{nodes}{an integer vector of length L >= 2 denoting a set of nodes in
the tree.}

\item{upperTriangle}{logical indicating if all duplicated entries and
diagonal entries should be set to NA (by default TRUE).}

\item{returnVector}{logical indicating if a vector instead of a matrix
 should be returned (corresponding to calling as.vector on the resulting
 matrix and removing
NAs). Default: TRUE}
}
\value{
a L x L logical matrix with TRUE on the diagonal and for each couple
of tips that belong to the same part or regime. If returnVector is TRUE
(default) only a vector of the non-NA entries will be returned.

a L x L logical matrix with TRUE on the diagonal and for each couple
of tips that belong to the same part or regime. If returnVector is TRUE (default)
only a vector of the non-NA entries will be returned.
}
\description{
Which couples from a given set of nodes in a tree belong to the same part?

Which couples from a given set of nodes in a tree belong to the same regime?
}
\examples{
set.seed(1, kind = "Mersenne-Twister", normal.kind = "Inversion")
tree <- PCMTree(ape::rtree(8))
PCMTreeMatrixNodesInSamePart(tree, returnVector = FALSE)

PCMTreeSetPartition(tree, c(10, 12))
PCMTreeMatrixNodesInSamePart(tree, returnVector = FALSE)

PCMTreeMatrixNodesInSamePart(tree)
PCMTreeMatrixNodesInSamePart(tree, seq_len(PCMTreeNumTips(tree)))
PCMTreeMatrixNodesInSamePart(
  tree, seq_len(PCMTreeNumTips(tree)), returnVector = FALSE)

set.seed(1, kind = "Mersenne-Twister", normal.kind = "Inversion")
tree <- PCMTree(ape::rtree(8))
PCMTreeMatrixNodesInSamePart(tree, returnVector = FALSE)

PCMTreeSetPartition(tree, c(10, 12))
PCMTreeMatrixNodesInSamePart(tree, returnVector = FALSE)

PCMTreeMatrixNodesInSamePart(tree)
PCMTreeMatrixNodesInSamePart(tree, seq_len(PCMTreeNumTips(tree)))
PCMTreeMatrixNodesInSamePart(
  tree, seq_len(PCMTreeNumTips(tree)), returnVector = FALSE)

}
