% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCM.R
\name{PCMInfo}
\alias{PCMInfo}
\title{Meta-information about a tree associated with a PCM}
\usage{
PCMInfo(X, tree, model, SE = matrix(0, PCMNumTraits(model),
  PCMTreeNumTips(tree)), verbose = FALSE, preorder = NULL, ...)
}
\arguments{
\item{X}{a \code{k x N} numerical matrix with possible \code{NA} and \code{NaN} entries. Each
column of X contains the measured trait values for one species (tip in tree).
Missing values can be either not-available (\code{NA}) or not existing (\code{NaN}).
Thse two values have are treated differently when calculating
likelihoods: see \code{\link{PCMPresentCoordinates}}.}

\item{tree}{a phylo object with N tips.}

\item{model}{an S3 object specifying both, the model type (class, e.g. "OU") as
well as the concrete model parameter values at which the likelihood is to be
calculated (see also Details).}

\item{SE}{a k x N matrix specifying the standard error for each measurement in
X. Alternatively, a k x k x N cube specifying an upper triangular k x k
Choleski factor of the variance covariance matrix for the measurement error
for each node i=1, ..., N.
Default: \code{matrix(0.0, PCMNumTraits(model), PCMTreeNumTips(tree))}.}

\item{verbose}{logical indicating if some debug-messages should printed.}

\item{preorder}{an integer vector of row-indices in tree$edge matrix as returned
by PCMTreePreorder. This can be given for performance speed-up when several
operations needing preorder are executed on the tree. Default : \code{NULL}.}

\item{...}{additional arguments used by implementing methods.}
}
\value{
a named list with the following elements:
\item{X}{k x N matrix denoting the trait data;}
\item{VE}{k x k x N array denoting the measurement error variance covariance
matrix for each for each tip i = 1,...,N. See the parameter \code{SE} in
\code{\link{PCMLik}.}}
\item{M}{total number of nodes in the tree;}
\item{N}{number of tips;}
\item{k}{number of traits;}
\item{RTree}{number of parts on the tree (distinct elements of tree$edge.part);}
\item{RModel}{number of regimes in the model (elements of attr(model, regimes));}
\item{p}{number of free parameters describing the model;}
\item{r}{an integer vector corresponding to tree$edge with the regime for each
branch in tree;}
\item{xi}{an integer vector of 0's and 1's corresponding to the rows in tree$edge
indicating the presence of a jump at the corresponding branch;}
\item{pc}{a logical matrix of dimension k x M denoting the present coordinates
for each node;}
This list is passed to \code{\link{PCMLik}}.
}
\description{
This function pre-processes the given tree and data in order to
create meta-information used during likelihood calculaiton.
}
