% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/person.posterior.R
\name{person.posterior}
\alias{person.posterior}
\title{Calculate Posterior Estimates for Person Parameters}
\usage{
person.posterior(model, cores = 30, tol = 1e-04, maxEval = 600, which = NULL)
}
\arguments{
\item{model}{Object of class \code{PCMRS}.}

\item{cores}{Number of cores to be used in parallelized computation.}

\item{tol}{The maximum tolerance for numerical integration, default 1e-4. 
For more details see \code{\link{adaptIntegrate}}.}

\item{maxEval}{The maximum number of function evaluations needed in numerical integration.
If specified as 0 implies no limit. For more details see \code{\link{adaptIntegrate}}.}

\item{which}{Optional vector to specify that only for a subset of all persons the posterior estimate is calculated.}
}
\value{
\item{}{Matrix containing all estimates of person parameters, both theta and gamma.}
}
\description{
Calculates posterior estimates for both person parameters, namely the ability parameters theta and the 
response style parameters gamma.
}
\examples{
\dontshow{
k <- 4; n <- 50; I <- 4
set.seed(1860)
Y <- as.data.frame(matrix(sample(1:k, I*n, TRUE),nrow = n))
Y <- data.frame(lapply(Y, as.ordered))

mini.ex <- PCMRS(Y, cores = 2)
mini.ex
}
\dontrun{
################################################
## Small example to illustrate model and person estimation
################################################

data(tenseness)

set.seed(5)
samples <- sample(1:nrow(tenseness), 100)
tense_small <- tenseness[samples,1:4]

m_small <- PCMRS(tense_small, cores = 2)
m_small
plot(m_small)

persons <- person.posterior(m_small, cores = 2)
plot(jitter(persons, 100))

################################################
## Example from Tutz et al. 2017:
################################################

data(emotion)
m.emotion <- PCMRS(emotion)
m.emotion

plot(m.emotion)
}
}
\references{
Tutz, Gerhard, Schauberger, Gunther and Berger, Moritz (2018): 
Response Styles in the Partial Credit Model, \emph{Applied Psychological Measurement}, \url{https://journals.sagepub.com/doi/10.1177/0146621617748322}
}
\seealso{
\code{\link{PCMRS}} \code{\link{PCMRS-package}}
}
\author{
Gunther Schauberger\cr \email{gunther.schauberger@tum.de}\cr
\url{https://www.sg.tum.de/epidemiologie/team/schauberger/}
}
\keyword{PCMRS}
