% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMR_deprecated.R
\name{phe_smr}
\alias{phe_smr}
\title{Calculate Indirectly Standardised Ratio (Standardised Mortality Ratio or
Standardised Admission Ratio) using calculate_ISRatio}
\usage{
phe_smr(
  data,
  x,
  n,
  x_ref,
  n_ref,
  refpoptype = "vector",
  type = "full",
  confidence = 0.95,
  refvalue = 1
)
}
\arguments{
\item{data}{data.frame containing the data to be standardised, pre-grouped if
multiple ISRs required; unquoted string; no default}

\item{x}{field name from data containing the observed number of events for
each standardisation category (eg ageband) within each grouping set (eg
area); unquoted string; no default}

\item{n}{field name from data containing the populations for each
standardisation category (eg ageband) within each grouping set (eg area);
unquoted string; no default}

\item{x_ref}{the observed number of events in the reference population for
each standardisation category (eg age band); unquoted numeric vector or
field name from data depending on value of refpoptype; no default}

\item{n_ref}{the reference population for each standardisation category (eg
age band); unquoted numeric vector or field name from data depending on
value of refpoptype; no default}

\item{refpoptype}{whether x_ref and n_ref have been specified as vectors or a
field name from data; quoted string "field" or "vector"; default = "vector"}

\item{type}{defines the data and metadata columns to be included in output;
can be "value", "lower", "upper", "standard" (for all data) or "full" (for
all data and metadata); quoted string; default = "full"}

\item{confidence}{the required level of confidence expressed as a number
between 0.9 and 1 or a number between 90 and 100 or can be a vector of 0.95
and 0.998, for example, to output both 95 percent and 99.8 percent percent CIs; numeric;
default 0.95}

\item{refvalue}{the standardised reference ratio, numeric, default = 1}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

To prevent ambiguity over the ISR acronym, the \code{phe_smr} function has been
replaced with a \code{calculate_ISRatio} function. Both functions take the same
parameters and provide identical functionality.  The \code{phe_smr} function will
remain available in the \code{PHEindicatormethods} package until at least December
2022 to allow users time to transfer existing code to use the new
\code{calculate_ISRatio} function. Please refer to the \code{calculate_ISRatio}
documentation for full support on the use of these functions.
}
\examples{
library(dplyr)
df <- data.frame(indicatorid = rep(c(1234, 5678, 91011, 121314), each = 19 * 2 * 5),
                 year = rep(2006:2010, each = 19 * 2),
                 sex = rep(rep(c("Male", "Female"), each = 19), 5),
                 ageband = rep(c(0,5,10,15,20,25,30,35,40,45,
                                 50,55,60,65,70,75,80,85,90), times = 10),
                 obs = sample(200, 19 * 2 * 5 * 4, replace = TRUE),
                 pop = sample(10000:20000, 19 * 2 * 5 * 4, replace = TRUE))

refdf <- data.frame(refcount = sample(200, 19, replace = TRUE),
                    refpop = sample(10000:20000, 19, replace = TRUE))

df \%>\%
    group_by(indicatorid, year, sex) \%>\%
    phe_smr(obs, pop, refdf$refcount, refdf$refpop, type="standard")

## OR

df \%>\%
    group_by(indicatorid, year, sex) \%>\%
    phe_smr(obs, pop, refdf$refcount, refdf$refpop, confidence=99.8, refvalue=100)


}
\keyword{internal}
