% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_classes.R
\docType{class}
\name{estimate.adjpin-class}
\alias{estimate.adjpin-class}
\alias{show,estimate.adjpin-method}
\title{AdjPIN estimation results}
\usage{
\S4method{show}{estimate.adjpin}(object)
}
\arguments{
\item{object}{(estimate.adjpin-class)}
}
\description{
The class \code{estimate.adjpin} is a blueprint of the \code{S4}
objects that store the results of the estimation of the \code{AdjPIN} model using
\code{adjpin()}.
}
\section{Slots}{

\describe{
\item{\code{success}}{(\code{logical}) takes the value \code{TRUE} when the estimation has
succeeded, \code{FALSE} otherwise.}

\item{\code{errorMessage}}{(\code{character})  contains an error message if the estimation
of the \code{AdjPIN} model has failed, and is empty otherwise.}

\item{\code{convergent.sets}}{(\code{numeric}) returns the number of initial parameter
sets, for which the likelihood maximization converged.}

\item{\code{method}}{(\code{character}) contains a reference to the estimation method:
\code{"ECM"} for expectation-conditional maximization algorithm and '\code{"ML"}'
for standard maximum likelihood estimation.}

\item{\code{factorization}}{(\code{character}) contains a reference to the factorization
of the likelihood function used: \code{"GE"}for the factorization in
\insertCite{Ersan2022b;textual}{PINstimation}, and \code{"NONE"} for the
original likelihood function in \insertCite{Duarte09;textual}{PINstimation}.}

\item{\code{restrictions}}{(\code{list}) returns a binary list that contains the set of
parameter restrictions on the original AdjPIN model in the estimated AdjPIN
model. The restrictions are imposed equality constraints on model parameters.
If the value of the parameter  \code{restricted} is the empty list \code{(list())},
then the model has no restrictions, and the estimated model is the
unrestricted, i.e., the original AdjPIN model. If not empty, the list
contains one or multiple of the following four elements
\verb{\{theta, mu, eps, d\}}. For instance, If \code{theta} is set to \code{TRUE},
then the estimated model has assumed the equality of the probability of
liquidity shocks in no-information, and information days, i.e.,
\thetaB\code{=}\thetaS. If any of the remaining rate elements
\verb{\{mu, eps, d\}} is equal to \code{TRUE}, (say  \code{mu=TRUE}), then the
estimated model imposed equality of the concerned parameter on the buy
side, and on the sell side (\mub\code{=}\mus). If more than one element is
equal to \code{TRUE},  then the restrictions are combined. For instance,
if  the slot \code{restrictions} contains \code{list(theta=TRUE, eps=TRUE, d=TRUE)},
then the estimated AdjPIN model has three restrictions \thetaB\code{=}\thetaS,
\eb\code{=}\es, and \Db\code{=}\Ds, i.e., it has been estimated with just \code{7}
parameters, in comparison to \code{10} in the original unrestricted model.}

\item{\code{algorithm}}{(\code{character}) returns the implemented initial parameter
set determination algorithm. \code{"GE"} is for
\insertCite{Ersan2022b;textual}{PINstimation},
\code{"CL"} is for \insertCite{ChengLai2021;textual}{PINstimation},
\code{"RANDOM"} for random initial parameter sets, and \code{"CUSTOM"} for
custom initial parameter sets.}

\item{\code{parameters}}{(\code{numeric}) returns the vector of the optimal
maximum-likelihood estimates ( \eqn{\alpha}, \eqn{\delta}, \eqn{\theta},
\eqn{\theta'}, \eb, \es, \mub, \mus, \Db, \Ds).}

\item{\code{likelihood}}{(\code{numeric}) returns the value (of the factorization) of the
likelihood function, as in \insertCite{Ersan2022b;textual}{PINstimation},
evaluated at the set of optimal parameters.}

\item{\code{adjpin}}{(\code{numeric}) returns the value of the adjusted probability of
informed trading \insertCite{Duarte09}{PINstimation}.}

\item{\code{psos}}{(\code{numeric}) returns the probability of symmetric order flow shock
\insertCite{Duarte09}{PINstimation}.}

\item{\code{dataset}}{(\code{dataframe}) returns the dataset of buys and sells used
in the estimation of the AdjPIN model.}

\item{\code{initialsets}}{(\code{dataframe}) returns the initial parameter sets used
in the estimation of AdjPIN model.}

\item{\code{details}}{(\code{dataframe}) returns a dataframe containing the estimated
parameters for each initial parameter set.}

\item{\code{hyperparams}}{(\code{list}) returns the hyperparameters of the \code{ECM} algorithm,
which are \code{maxeval}, and \code{tolerance}.}

\item{\code{runningtime}}{(\code{numeric}) returns the running time of the \code{AdjPIN}
estimation in seconds.}
}}

