% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse.R
\name{sparse_auc_weight_linear}
\alias{sparse_auc_weight_linear}
\title{Calculate the weight for sparse AUC calculation with the linear-trapezoidal
rule}
\usage{
sparse_auc_weight_linear(sparse_pk)
}
\arguments{
\item{sparse_pk}{A sparse_pk object from \code{\link{as_sparse_pk}}}
}
\value{
A numeric vector of weights for sparse AUC calculations the same
  length as \code{sparse_pk}
}
\description{
The weight is used as the \eqn{w_i}{w_i} parameter in
\code{\link{pk.calc.sparse_auc}}
}
\details{
\deqn{w_i = \frac{\delta_{time,i-1,i} + \delta_{time,i,i+1}}{2}}{w_i = (d_time[i-1,i] + d_time[i,i+1])/2}
\deqn{\delta_{time,i,i+1} = t_{i+1} - t_i}{d_time = t_[i+1] - t_i, and zero if i < 1 or i > K}

Where:

\itemize{
  \item{\eqn{w_i}{w_i}}{is the weight at time i}
  \item{\eqn{\delta_{time,i-1,i}}{d_time[i-1,i]} and \eqn{\delta_{time,i,i+1}}{d_time[i,i+1]}}{are the changes between time i-1 and i or i and i+1 (zero outside of the time range)}
  \item{\eqn{t_i}{t_i}}{is the time at time i}
}
}
\seealso{
Other Sparse Methods: 
\code{\link{as_sparse_pk}()},
\code{\link{pk.calc.sparse_auc}()},
\code{\link{sparse_mean}()}
}
\concept{Sparse Methods}
