% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk.calc.simple.R
\name{pk.calc.cl}
\alias{pk.calc.cl}
\alias{pk.calc.cl.all}
\alias{pk.calc.cl.last}
\alias{pk.calc.cl.obs}
\alias{pk.calc.cl.pred}
\title{Calculate the (observed oral) clearance}
\usage{
pk.calc.cl(dose, aucinf)

pk.calc.cl.last(dose, auclast)

pk.calc.cl.all(dose, aucall)

pk.calc.cl.obs(dose, aucinf.obs)

pk.calc.cl.pred(dose, aucinf.pred)
}
\arguments{
\item{dose}{the dose administered}

\item{aucinf, aucinf.obs, aucinf.pred}{The area under the concentration-time 
curve from 0 to infinity (the next dose on a regular schedule at 
steady-state)}

\item{auclast}{The area under the concentration-time curve from 0 to the last
measurement above the LOQ.}

\item{aucall}{The area under the concentration-time curve from 0 to the last 
measurement above the limit of quantifiation (LOQ) plus the triangle to the
first concentration below the LOQ.}
}
\value{
the numeric value of the total (CL) or observed oral clearance (CL/F)
}
\description{
Calculate the (observed oral) clearance
}
\details{
If \code{dose} is the same length as the other inputs, then the 
  output will be the same length as all of the inputs; the function assumes 
  that you are calculating for multiple intervals simultaneously.  If the 
  inputs other than \code{dose} are scalars and \code{dose} is a vector, then
  the function assumes multiple doses were given in a single interval, and 
  the sum of the \code{dose}s will be used for the calculation.
}
\section{Functions}{
\itemize{
\item \code{pk.calc.cl.last}: Compute the clearance from AUClast

\item \code{pk.calc.cl.all}: Compute the clearance from AUCall

\item \code{pk.calc.cl.obs}: Compute the clearance from AUCinf (calculated from 
observed Clast)

\item \code{pk.calc.cl.pred}: Compute the clearance from AUCinf (calculated from
predicted Clast)
}}
\references{
Gabrielsson J, Weiner D. "Section 2.5.1 Derivation of clearance."
  Pharmacokinetic & Pharmacodynamic Data Analysis: Concepts and Applications,
  4th Edition.  Stockholm, Sweden: Swedish Pharmaceutical Press, 2000. 86-7.
}

