% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tss.R
\name{pk.tss.data.prep}
\alias{pk.tss.data.prep}
\title{Clean up the time to steady-state parameters and return a data
frame for use by the tss calculators.}
\usage{
pk.tss.data.prep(conc, time, subject, treatment, subject.dosing, time.dosing,
  options = list(), conc.blq = NULL, conc.na = NULL, check = TRUE, ...)
}
\arguments{
\item{conc}{Concentration measured}

\item{time}{Time of concentration measurement}

\item{subject}{Subject identifiers (used as a random effect in the
model)}

\item{treatment}{Treatment description (if missing, all subjects
are assumed to be on the same treatment)}

\item{subject.dosing}{Subject number for dosing}

\item{time.dosing}{Time of dosing}

\item{options}{List of changes to the default
\code{\link{PKNCA.options}} for calculations.}

\item{conc.blq}{See \code{\link{clean.conc.blq}}}

\item{conc.na}{See \code{\link{clean.conc.na}}}

\item{check}{Run \code{\link{check.conc.time}}?}

\item{\dots}{Discarded inputs to allow generic calls between tss
methods.}
}
\value{
a data frame with columns for \code{conc}entration,
\code{time}, \code{subject}, and \code{treatment}.
}
\description{
Clean up the time to steady-state parameters and return a data
frame for use by the tss calculators.
}
