% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time.above.R
\name{pk.calc.time_above}
\alias{pk.calc.time_above}
\title{Determine time at or above a set value}
\usage{
pk.calc.time_above(
  conc,
  time,
  conc_above,
  method,
  options = list(),
  check = TRUE
)
}
\arguments{
\item{conc}{Concentration measured}

\item{time}{Time of concentration measurement (must be monotonically
increasing and the same length as the concentration data)}

\item{conc_above}{The concentration to be above (if missing will use
\code{PKNCA.choose.option(name="conc_above", value=conc_above, options=options)})}

\item{method}{The method for integration (either 'lin up/log down' or
'linear')}

\item{options}{List of changes to the default \code{\link{PKNCA.options}} for
calculations.}

\item{check}{Run \code{\link{check.conc.time}}, \code{\link{clean.conc.blq}},
and \code{\link{clean.conc.na}}?}
}
\value{
the time above the given concentration
}
\description{
Interpolation is performed aligning with \code{PKNCA.options("auc.method")}.
Extrapolation outside of the measured times is not yet implemented.
}
