% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_parameters.R
\name{calculate_parameters}
\alias{calculate_parameters}
\title{Calculate model-specific variables using a dummy call to sim_ode()}
\usage{
calculate_parameters(
  ode = NULL,
  parameters = NULL,
  covariates = NULL,
  include_parameters = TRUE,
  include_variables = TRUE,
  ...
)
}
\arguments{
\item{ode}{PKPDsim model object}

\item{parameters}{parameter list}

\item{covariates}{covariate list. Make sure to include covariates at the right time point, since only last observed covariate values are used.}

\item{include_parameters}{boolean, include parameters?}

\item{include_variables}{boolean, include variables?}

\item{...}{arguments to pass on to simulation function}
}
\value{
List of model-specific variables
}
\description{
This is a convenience function for PKPDsim users, it is not used inside the `sim_ode()``
function in any way.
This function is useful for converting from an estimated parameter to actual parameter,
e.g. when clearance is specified as `CLi = CL * (WT/70) * (1/CR)` it can be used to
calculate `CLi` without having to write that function a second time in R.
}
