% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNmixturefamily-class.R
\name{PLNmixturefamily}
\alias{PLNmixturefamily}
\title{An R6 Class to represent a collection of PLNmixturefit}
\description{
The function \code{\link[=PLNmixture]{PLNmixture()}} produces an instance of this class.

This class comes with a set of methods, some of them being useful for the user:
See the documentation for \code{\link[=getBestModel]{getBestModel()}}, \code{\link[=getModel]{getModel()}} and \code{\link[=plot.PLNmixturefamily]{plot()}}.
}
\seealso{
The function \code{\link{PLNmixture}}, the class \code{\link[=PLNmixturefit]{PLNmixturefit}}
}
\section{Super class}{
\code{\link[PLNmodels:PLNfamily]{PLNmodels::PLNfamily}} -> \code{PLNmixturefamily}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{clusters}}{vector indicating the number of clusters considered is the successively fitted models}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PLNmixturefamily$new()}}
\item \href{#method-optimize}{\code{PLNmixturefamily$optimize()}}
\item \href{#method-smooth}{\code{PLNmixturefamily$smooth()}}
\item \href{#method-plot}{\code{PLNmixturefamily$plot()}}
\item \href{#method-plot_objective}{\code{PLNmixturefamily$plot_objective()}}
\item \href{#method-getBestModel}{\code{PLNmixturefamily$getBestModel()}}
\item \href{#method-show}{\code{PLNmixturefamily$show()}}
\item \href{#method-print}{\code{PLNmixturefamily$print()}}
\item \href{#method-clone}{\code{PLNmixturefamily$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfamily" data-id="getModel">}\href{../../PLNmodels/html/PLNfamily.html#method-getModel}{\code{PLNmodels::PLNfamily$getModel()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfamily" data-id="postTreatment">}\href{../../PLNmodels/html/PLNfamily.html#method-postTreatment}{\code{PLNmodels::PLNfamily$postTreatment()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize all models in the collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNmixturefamily$new(
  clusters,
  responses,
  covariates,
  offsets,
  formula,
  xlevels,
  control
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{clusters}}{the dimensions of the successively fitted models}

\item{\code{responses}}{the matrix of responses common to every models}

\item{\code{covariates}}{the matrix of covariates common to every models}

\item{\code{offsets}}{the matrix of offsets common to every models}

\item{\code{formula}}{model formula used for fitting, extracted from the formula in the upper-level call}

\item{\code{xlevels}}{named listed of factor levels included in the models, extracted from the formula in the upper-level call #'}

\item{\code{control}}{a list for controlling the optimization. See details.}

\item{\code{control}}{a list for controlling the optimization. See details.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-optimize}{}}}
\subsection{Method \code{optimize()}}{
Call to the optimizer on all models of the collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNmixturefamily$optimize(control)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{control}}{a list for controlling the optimization. See details.}

\item{\code{control}}{a list for controlling the optimization. See details.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-smooth"></a>}}
\if{latex}{\out{\hypertarget{method-smooth}{}}}
\subsection{Method \code{smooth()}}{
function to restart clustering to avoid local minima by smoothing the loglikelihood values as a function of the number of clusters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNmixturefamily$smooth(control)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{control}}{a list to control the smoothing process}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot"></a>}}
\if{latex}{\out{\hypertarget{method-plot}{}}}
\subsection{Method \code{plot()}}{
Lineplot of selected criteria for all models in the collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNmixturefamily$plot(criteria = c("loglik", "BIC", "ICL"), reverse = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{criteria}}{A valid model selection criteria for the collection of models. Any of "loglik", "BIC" or "ICL" (all).}

\item{\code{reverse}}{A logical indicating whether to plot the value of the criteria in the "natural" direction
(loglik - 0.5 penalty) or in the "reverse" direction (-2 loglik + penalty). Default to FALSE, i.e use the
natural direction, on the same scale as the log-likelihood..}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{ggplot2}} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_objective"></a>}}
\if{latex}{\out{\hypertarget{method-plot_objective}{}}}
\subsection{Method \code{plot_objective()}}{
Plot objective value of the optimization problem along the penalty path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNmixturefamily$plot_objective()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a \code{\link{ggplot}} graph
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getBestModel"></a>}}
\if{latex}{\out{\hypertarget{method-getBestModel}{}}}
\subsection{Method \code{getBestModel()}}{
Extract best model in the collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNmixturefamily$getBestModel(crit = c("BIC", "ICL", "loglik"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{crit}}{a character for the criterion used to performed the selection. Either
"BIC", "ICL" or "loglik". Default is \code{ICL}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a \code{\link{PLNmixturefit}} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\if{latex}{\out{\hypertarget{method-show}{}}}
\subsection{Method \code{show()}}{
User friendly print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNmixturefamily$show()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
User friendly print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNmixturefamily$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNmixturefamily$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
