% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/durbinAllPairsTest.R
\name{durbinAllPairsTest}
\alias{durbinAllPairsTest}
\alias{durbinAllPairsTest.default}
\title{All-Pairs Comparisons Test for Balanced Incomplete Block Designs}
\usage{
durbinAllPairsTest(y, ...)

\method{durbinAllPairsTest}{default}(y, groups, blocks, p.adjust.method = p.adjust.methods, ...)
}
\arguments{
\item{y}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{groups}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}. Ignored with a warning if \code{"x"} is a list.}

\item{blocks}{a vector or factor object giving the block for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{p.adjust.method}{method for adjusting p values
(see \code{\link{p.adjust}})}

\item{\ldots}{further arguments to be passed to or from methods.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
 \item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs Conover-Iman all-pairs comparison test for a balanced incomplete
block design (BIBD).
}
\details{
For all-pairs comparisons in a balanced incomplete block design
the proposed test of Conover and Imam can be applied.
A total of \eqn{m = k(k-1)/2}
hypotheses can be tested. The null hypothesis
H\eqn{_{ij}: \theta_i = \theta_j} is tested in the two-tailed test
against the alternative
A\eqn{_{ij}: \theta_i \ne \theta_j, ~~ i \ne j}.

The p-values are computed from the t distribution. If no p-value adjustment
is performed (\code{p.adjust.method = "none"}),
than a simple protected test is recommended, i.e.
the all-pairs comparisons should only be applied after a significant
\code{\link{durbinTest}}. However, any method as implemented in
\code{\link{p.adjust.methods}} can be selected by the user.
}
\examples{
## Example for an incomplete block design:
## Data from Conover (1999, p. 391).
y <- matrix(c(2,NA,NA,NA,3, NA,  3,  3,  3, NA, NA, NA,  3, NA, NA,
  1,  2, NA, NA, NA,  1,  1, NA,  1,  1,
NA, NA, NA, NA,  2, NA,  2,  1, NA, NA, NA, NA,
 3, NA,  2,  1, NA, NA, NA, NA,  3, NA,  2,  2),
ncol=7, nrow=7, byrow=FALSE, dimnames=list(1:7, LETTERS[1:7]))
durbinAllPairsTest(y)
}
\references{
Conover, W. J., Iman, R. L. (1979) \emph{On multiple-comparisons
 procedures}, Tech. Rep. LA-7677-MS, Los Alamos Scientific Laboratory.

Conover, W. J. (1999) \emph{Practical nonparametric Statistics},
3rd. Edition, Wiley.
}
\seealso{
\code{\link{durbinTest}}
}
\concept{friedmanranks}
\keyword{htest}
\keyword{nonparametric}
