% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTest.R
\name{MTest}
\alias{MTest}
\alias{MTest.default}
\alias{MTest.formula}
\alias{MTest.aov}
\title{Extended One-Sided Studentised Range Test}
\usage{
MTest(x, ...)

\method{MTest}{default}(x, g, alternative = c("greater", "less"), ...)

\method{MTest}{formula}(
  formula,
  data,
  subset,
  na.action,
  alternative = c("greater", "less"),
  ...
)

\method{MTest}{aov}(x, alternative = c("greater", "less"), ...)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis. Defaults to \code{greater}.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
\describe{
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
\item{statistic}{the estimated statistic(s)}
\item{crit.value}{critical values for \eqn{\alpha = 0.05}.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{parameter}{the parameter(s) of the test distribution.}
\item{dist}{a string that denotes the test distribution.}
}
There are print and summary methods available.
}
\description{
Performs Nashimoto-Wright's extended
one-sided studentised range
test against an ordered alternative for normal data
with equal variances.
}
\details{
The procedure uses the property of a simple order,
\eqn{\theta_m' - \mu_m \le \mu_j - \mu_i \le \mu_l' - \mu_l
\qquad (l \le i \le m~\mathrm{and}~ m' \le j \le l')}.
The null hypothesis H\eqn{_{ij}: \mu_i = \mu_j} is tested against
the alternative A\eqn{_{ij}: \mu_i < \mu_j} for any
\eqn{1 \le i < j \le k}.

The all-pairs comparisons test statistics for a balanced design are
\deqn{
 \hat{h}_{ij} = \max_{i \le m < m' \le j} \frac{\left(\bar{x}_{m'} - \bar{x}_m \right)}
 {s_{\mathrm{in}} / \sqrt{n}},
}{%
 SEE PDF
}

with \eqn{n = n_i; ~ N = \sum_i^k n_i ~~ (1 \le i \le k)}, \eqn{\bar{x}_i} the arithmetic mean of the \eqn{i}th group,
and \eqn{s_{\mathrm{in}}^2} the within ANOVA variance. The null hypothesis is rejected,
if \eqn{\hat{h} > h_{k,\alpha,v}}, with \eqn{v = N - k}
degree of freedom.

For the unbalanced case with moderate imbalance the test statistic is
\deqn{
 \hat{h}_{ij} = \max_{i \le m < m' \le j} \frac{\left(\bar{x}_{m'} - \bar{x}_m \right)}
 {s_{\mathrm{in}} \left(1/n_m + 1/n_{m'}\right)^{1/2}},
}{%
 SEE PDF
}

The null hypothesis is rejected, if \eqn{\hat{h}_{ij} > h_{k,\alpha,v} / \sqrt{2}}.

The function does not return p-values. Instead the critical h-values
as given in the tables of Hayter (1990) for \eqn{\alpha = 0.05} (one-sided)
are looked up according to the number of groups (\eqn{k}) and
the degree of freedoms (\eqn{v}).
}
\note{
The function will give a warning for the unbalanced case and returns the
critical value \eqn{h_{k,\alpha,\infty} / \sqrt{2}}.
}
\examples{
##
md <- aov(weight ~ group, PlantGrowth)
anova(md)
osrtTest(md)
MTest(md)
}
\references{
Hayter, A. J.(1990) A One-Sided Studentised Range
Test for Testing Against a Simple Ordered Alternative,
\emph{Journal of the American Statistical Association}
\bold{85}, 778--785.

Nashimoto, K., Wright, F.T., (2005) Multiple comparison procedures
for detecting differences in simply ordered means.
\emph{Comput. Statist. Data Anal.} \bold{48}, 291--306.
}
\seealso{
\code{\link{osrtTest}}, \code{\link{NPMTest}}
}
\concept{parametric}
\keyword{htest}
