% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pnadc.R
\name{get_pnadc}
\alias{get_pnadc}
\title{Download and read PNADc microdata}
\usage{
get_pnadc(quarter, year, vars = NULL, savedir = tempdir())
}
\arguments{
\item{quarter}{The quarter of the year of the data to be downloade. must be number from 1 to 4. Vector not accepted.}

\item{year}{the year of the data to be downloaded.must be a number between 2012 and current year. Vector not accepted.}

\item{vars}{Character vector of the name of the variables you want to keep for analysys. \code{default} is to keep all variables}

\item{savedir}{Directory for dowloading data. \code{default} is to use a temporary directory.}
}
\value{
A tibble with the survey design variables and selected variables.
}
\description{
Download and read PNADc microdata
}
\examples{
\dontrun{
pnadc.df <- get_pnadc(2,2016)
pnadc.df2 <- get_pnadc(1,2017,vars=c("VD4001","VD4002"))}

}
