% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.Rcpp_POSet.R
\name{print.Rcpp_POSet}
\alias{print.Rcpp_POSet}
\title{Method for the print function that shows the poset elements and comparabilities}
\usage{
\method{print}{Rcpp_POSet}(x, max = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{Rcpp_POSet}.}

\item{max}{a non-null value for max specifies the approximate maximum number of entries to be printed. The default, NULL, uses \code{\link{getOption}("max.print")}: see that help page for more details.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
nothing
}
\description{
\code{print} prints the list of poset elements and all of the strict dominances in it.
}
\examples{
dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)
p <- poset(x = dom)
print(p)
}
