% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRANA.R
\name{PRANA}
\alias{PRANA}
\title{PRANA}
\usage{
PRANA(RNASeqdat, clindat, groupA, groupB)
}
\arguments{
\item{RNASeqdat}{An RNA-Seq data with subjects in rows and genes in columns.}

\item{clindat}{A data with clinical variables to be included in the regression
(e.g., binary group variable indicating
current smoking status, continuous age, ...)}

\item{groupA}{Indices of the subjects in the first category (e.g., non-current smoker)
of binary group variable.}

\item{groupB}{Indices of the subjects in the second category (e.g., current smoker)
of binary group variable.}
}
\value{
A list containing three data frame objects that summarize the results of PRANA. This includes
        beta coefficients, p-values, and adjusted p-values via the empirical Bayes approach
        for each predictor variables that are included in the regression model.
}
\description{
A pseudo-value regression approach for differential network analysis
    that adjusts for additional covariates (PRANA)
}
\examples{
data(combinedCOPDdat_RGO) # A complete data containing expression and clinical data.

# A gene expression data part of the downloaded data.
rnaseqdat = combinedCOPDdat_RGO[ , 8:ncol(combinedCOPDdat_RGO)]
rnaseqdat = as.data.frame(apply(rnaseqdat, 2, as.numeric))

# A clinical data with additional covariates sorted by current smoking groups:
# The first column is ID, so do not include.
phenodat = combinedCOPDdat_RGO[order(combinedCOPDdat_RGO$currentsmoking), 2:7]

# Indices of non-current smoker (namely Group A)
index_grpA = which(combinedCOPDdat_RGO$currentsmoking == 0)
# Indices of current smoker (namely Group B)
index_grpB = which(combinedCOPDdat_RGO$currentsmoking == 1)

PRANAres <- PRANA(RNASeqdat = rnaseqdat, clindat = phenodat,
groupA = index_grpA, groupB = index_grpB)
}
\references{
Ahn S, Grimes T, Datta S. A pseudo-value regression approach for differential network analysis of co-expression data. BMC Bioinformatics, 2023;24(1):8
}
