% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configPROsetta.R
\name{runCFA}
\alias{runCFA}
\title{Run a confirmatory factor analysis}
\usage{
runCFA(data, estimator = "WLSMV", std.lv = TRUE, scalewise = FALSE, ...)
}
\arguments{
\item{data}{a \code{\linkS4class{PROsetta_data}} object. See \code{\link{loadData}} for loading a dataset.}

\item{estimator}{the estimator to be used. Passed onto \code{\link[lavaan]{cfa}} in \href{https://CRAN.R-project.org/package=lavaan}{'lavaan'} package.}

\item{std.lv}{if \code{TRUE}, the metric of the latent variable is determined by fixing their (residual) variances to 1.0. If \code{FALSE}, the metric of each latent variable is determined by fixing the factor loading of the first indicator to 1.0. Passed onto \code{\link[lavaan]{cfa}}.}

\item{scalewise}{if TRUE, run analysis for each scale as well as for the combined scale. If FALSE (default), run analysis only for the combined scale.}

\item{...}{additional arguments to pass onto \code{\link[lavaan]{cfa}}.}
}
\value{
\code{\link{runCFA}} returns a list containing the CFA results.
}
\description{
\code{\link{runCFA}} is a function to perform a one-factor confirmatory factor analysis (CFA) to test unidimensionality.
}
\examples{
\donttest{
out_cfa <- runCFA(data_asq, scalewise = TRUE)
lavaan::summary(out_cfa$`1`       , fit.measures = TRUE, standardized = TRUE, estimates = FALSE)
lavaan::summary(out_cfa$`2`       , fit.measures = TRUE, standardized = TRUE, estimates = FALSE)
lavaan::summary(out_cfa$`combined`, fit.measures = TRUE, standardized = TRUE, estimates = FALSE)
}
}
