#' @title Live stock, poultry, fish, forestry, honey bee data from Pakistan Social and Living Standards Measurement 2015-16 
#' @name   LiveStock
#' @docType data
#' @keywords datasets
#' @usage data(LiveStock)
#' @description \code{LiveStock} Live stock, poultry, fish, forestry, honey bee data from Pakistan Social and Living Standards Measurement 2015-16.
#' @format A \code{data.table} and  \code{data.frame} with 51322 obs. of  13 variables.
#' \describe{
#'        \item{\code{hhcode}}{10 digits Household code.}
#'        \item{\code{Province}}{Province of Pakistan}
#'        \item{\code{Region}}{Urban or Rural area of Pakitan}
#'        \item{\code{Psu}}{08 digits code of primary sampling unit}
#'        \item{\code{sec}}{Questionair section}
#'        \item{\code{Code}}{Live stock activities}
#'        \item{\code{S7b00}}{Direct mix response from respondent}
#'        \item{\code{S7bc1}}{Direct mix response from respondent}
#'        \item{\code{S7bc2}}{Direct mix response from respondent}
#'        \item{\code{S7bc3}}{Direct mix response from respondent}
#'        \item{\code{S7bc4}}{Direct mix response from respondent}
#'        \item{\code{S7bc5}}{Direct mix response from respondent}
#'        \item{\code{S7bc6}}{Direct mix response from respondent}
#'        }
#' @author Muhammad Yaseen (\email{myaseen208@gmail.com})
#' @author Muhammad Arfan Dilber (\email{pbsfsd041@gmail.com})
#' 
#' @references \enumerate{
#' \item Pakistan Bureau of Statistics, Micro data (\url{http://www.pbs.gov.pk/}).
#'  }
#'
#' @seealso 
#'    \code{\link{Agriculture}}
#'  , \code{\link{AssetLiability}}
#'  , \code{\link{Education}}
#'  , \code{\link{Employment}}
#'  , \code{\link{Expenditure}}
#'  , \code{\link{ICT}}
#'  , \code{\link{Income}}
#'  , \code{\link{Land}}
#'  , \code{\link{NonAgriculture}}
#'  , \code{\link{OtherIncome}}
#'  , \code{\link{PaidReceived}}
#'  , \code{\link{SurveyInfo}}
NULL