% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DISSULFID.R
\name{disulfid}
\alias{disulfid}
\title{Disulfide connectivity feature}
\usage{
disulfid(pssm_name)
}
\arguments{
\item{pssm_name}{name of PSSM Matrix file}
}
\value{
a table with number of all cyctein pairs in rows and 521 columns correspond to feature vector length.
}
\description{
This feature is used to predict the disulfide bond within a protein.
}
\details{
For the purpose of predicting disulfide bond in protein at first, the total
number of cysteine amino acids in the protein sequence is counted and their position in the protein sequence is
identified. Then, using a sliding window with length of 13, moved on the PSSM matrix from top to bottom so that
the middle of the window is on the amino acid cysteine, then the rows below the matrix obtained from the PSSM
matrix with dimension of 13 x 20 are placed next to each other to get a feature vector with a length of
260 = 20 * 13 per cysteine, and if the position of the first and last cysteine in the protein sequence is such
that the middle of sliding window is not on cysteine residue when moving on PSSM Matrix, then the required
number of zero rows from top and bottom is added to the PSSM matrix to achieve this goal.Thus, for every
cystine amino acid presented in protein sequence, a feature vector with a length of 260 is formed.Then all
the pairwise combinations of these cysteines is wrote in the first column of a table, and in front of each of these
pairwise combinations, the corresponding feature vectors are sticked together to get a feature vector of length 520
for each of these compounds.Finally, the table obtained in this way will have the number of rows equal to the
number of all pairwise combinations of these cysteines and the number of columns will be equal to 521
(the first column includes the name of these pair combinations). And it is easy to divide this table into
training and testing data and predict the desired disulfide bonds between cysteines.
}
\examples{
aq<-disulfid(system.file("extdata", "C7GQS7.txt.pssm", package="PSSMCOOL"))
}
\references{
D.-J. Yu et al., "Disulfide connectivity prediction based on modelled protein 3D structural information and
random forest regression," vol. 12, no. 3, pp. 611-621, 2014.

N. J. Mapes Jr, C. Rodriguez, P. Chowriappa, S. J. C. Dua, and s. b. journal, "Residue adjacency matrix based
feature engineering for predicting cysteine reactivity in proteins," vol. 17, pp. 90-100, 2019.
}
