% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_plots.R
\name{plot_MissedCleavages}
\alias{plot_MissedCleavages}
\title{Plot bargraph of missed cleavages.}
\usage{
plot_MissedCleavages(data, title_sub = "")
}
\arguments{
\item{data}{A data.frame with columns 'fc.raw.file', '...' (missed cleavage classes)}

\item{title_sub}{Plot's subtitle}
}
\value{
GGplot object
}
\description{
Per Raw file, an arbitrary number of missed cleavage classes (one per column) can be given.
The total fraction of 3D-peaks must sum to 1 (=100%).
Columns are ordered by name.
}
\details{
A visual threshold line is drawn at 75% (expected MC0 count).
}
\examples{
  data = data.frame(fc.raw.file = letters[1:5],
                    MC0 = c(0.8, 0.5, 0.85, 0.2, 0.9),
                    MC1 = c(0.1, 0.4, 0.05, 0.7, 0.0),
                    "MS2+" =  c(0.1, 0.1, 0.1, 0.1, 0.1),
                    check.names = FALSE)
  plot_MissedCleavages(data, "contaminant inclusion unknown")

}

