% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asy_1911_seg_plr_function.R
\name{plr_seg_extract}
\alias{plr_seg_extract}
\title{Segmented linear PLR extraction function}
\usage{
plr_seg_extract(
  df,
  per_year,
  psi = NA,
  n_breakpoints,
  power_var,
  time_var,
  return_model = FALSE
)
}
\arguments{
\item{df}{data frame of corrected power measurements, typically the output of a weather correction model}

\item{per_year}{number of data point defining one seasonal year (365 for days, 52 for weeks etc.)}

\item{psi}{vector of 1 or more breakpoint estimates for the model. If not given will evenly space breakpoints across time series}

\item{n_breakpoints}{number of desired breakpoints. Determines number of linear models}

\item{power_var}{character name of the power variable}

\item{time_var}{character name of the time variable}

\item{return_model}{logical to return model object. If FALSE returns PLR results from model}
}
\value{
if return_model is FALSE it returns PLR results from model, otherwise returns segmented linear model object
}
\description{
Segmented linear PLR extraction function
}
\examples{
# build var_list
var_list <- plr_build_var_list(time_var = "timestamp",
                               power_var = "power",
                               irrad_var = "g_poa",
                               temp_var = "mod_temp",
                               wind_var = NA)
# Clean Data
test_dfc <- plr_cleaning(test_df, var_list, irrad_thresh = 100,
                         low_power_thresh = 0.01, high_power_cutoff = NA)
                         
#' # Perform power modeling step
test_xbx_wbw_res <- plr_xbx_model(test_dfc, var_list, by = "week",
                                  data_cutoff = 30, predict_data = NULL)
                                  
decomp <- plr_decomposition(test_xbx_wbw_res, freq = 4,
                                         power_var = 'power_var', time_var = 'time_var',
                                         plot = FALSE, plot_file = NULL, title = NULL, 
                                         data_file = NULL)

# evaluate segmented PLR results
seg_plr_result <- PVplr::plr_seg_extract(df = decomp, per_year = 365,
                                         n_breakpoints = 1, power_var = "trend",
                                         time_var = "age")

# return segmented model instead of PLR result
model <- PVplr::plr_seg_extract(df = decomp, per_year = 365, n_breakpoints = 1,
                                power_var = "trend", time_var = "age", return_model = TRUE)

# predict data along time-series with piecewise model for plotting
pred <- data.frame(age = seq(1, max(decomp$age, na.rm = TRUE), length.out = 10000))
pred$seg <- predict(model, newdata = pred)

}
