% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epa_createMetaDataframe.R
\name{epa_createMetaDataframe}
\alias{epa_createMetaDataframe}
\title{Create Sites Metadata Dataframe}
\usage{
epa_createMetaDataframe(tbl, pwfslDataIngestSource = "EPA",
  existingMeta = NULL, addGoogleMeta = TRUE)
}
\arguments{
\item{tbl}{an EPA raw tibble after metadata enhancement}

\item{pwfslDataIngestSource}{identifier for the source of monitoring data, e.g. \code{'EPA_hourly_88101_2016.zip'}}

\item{existingMeta}{existing 'meta' dataframe from which to obtain metadata for known monitor deployments}

\item{addGoogleMeta}{logicial specifying wheter to use Google elevation and reverse geocoding services}
}
\value{
A \code{meta} dataframe for use in a \emph{ws_monitor} object.
}
\description{
After addtional columns(i.e. \code{datetime}, and \code{monitorID}) 
have been applied to an EPA dataframe, we are ready to 
pull out site information associated with unique monitorID.

These will be rearranged into a dataframe organized as deployment-by-property
with one row for each monitorID.

This site information found in \code{tbl} is augmented so that we end up with a uniform
set of properties associated with each monitorID. The list of
columns in the returned \code{meta} dataframe is:

\preformatted{
> names(p$meta)
 [1] "monitorID"             "longitude"             "latitude"             
 [4] "elevation"             "timezone"              "countryCode"          
 [7] "stateCode"             "siteName"              "agencyName"           
[10] "countyName"            "msaName"               "monitorType"          
[13] "monitorInstrument"     "aqsID"                 "pwfslID"              
[16] "pwfslDataIngestSource" "telemetryAggregator"   "telemetryUnitID"      
}
}
\references{
\href{https://aqs.epa.gov/aqsweb/airdata/download_files.html#Raw}{EPA AirData Pre-Generated Data Files}

\href{https://aqs.epa.gov/aqsweb/airdata/FileFormats.html#_format_3}{file format description}
}
\keyword{EPA}
