% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrcc_parseData.R
\name{wrcc_parseData}
\alias{wrcc_parseData}
\title{Parse WRCC data string}
\usage{
wrcc_parseData(fileString)
}
\arguments{
\item{fileString}{character string containing WRCC data}
}
\value{
Dataframe of WRCC raw monitor data.
}
\description{
Raw character data from WRCC are parsed into a tibble.
The incoming \code{fileString}
can be read in directly from WRCC using \code{wrcc_downloadData()} or from a local
file using \code{readr::read_file()}.

The type of monitor represented by this fileString is inferred from the column names
using \code{wrcc_identifyMonitorType()} and appropriate column types are assigned.
The character data are then processed, read into a tibble and augmented in the following ways:
\enumerate{
\item{Spaces at the beginning and end of each line are moved.}
\item{All header lines beginning with ':' are removed.}
}
}
\examples{
\dontrun{
fileString <- wrcc_downloadData(20150701, 20150930, unitID = 'SM16')
tbl <- wrcc_parseData(fileString)
}
}
\references{
\href{https://wrcc.dri.edu/cgi-bin/smoke.pl}{Fire Cache Smoke Monitoring Archive}
}
\keyword{WRCC}
