% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawPlot_timeOfDaySpaghetti.R
\name{rawPlot_timeOfDaySpaghetti}
\alias{rawPlot_timeOfDaySpaghetti}
\title{Create Time of Day Spaghetti Plot from a Raw Dataframe}
\usage{
rawPlot_timeOfDaySpaghetti(
  df,
  parameter = "pm25",
  tlim = NULL,
  shadedNight = TRUE,
  meanCol = "black",
  meanLwd = 4,
  meanLty = 1,
  highlightDates = c(),
  highlightCol = "dodgerblue",
  ...
)
}
\arguments{
\item{df}{enhanced, raw dataframe as created by the \code{raw_enhance()} function}

\item{parameter}{variable to be plotted}

\item{tlim}{optional vector with start and end times (integer or character representing YYYYMMDD[HH])}

\item{shadedNight}{add nighttime shading}

\item{meanCol}{color used for the mean line (use \code{NA} to omit the mean)}

\item{meanLwd}{line width used for the mean line}

\item{meanLty}{line type used for the mean line}

\item{highlightDates}{dates to be highlighted in YYYYMMDD format}

\item{highlightCol}{color used for highlighted days}

\item{...}{additional graphical parameters are passed to the \code{lines()} function for day lines}
}
\description{
Spaghetti Plot that shows data by hour-of-day.
}
\examples{
\dontrun{
raw <- airsis_createRawDataframe(20160901, 20161015, 'USFS', 1012)
raw <- raw_enhance(raw)
rawPlot_timeOfDaySpaghetti(raw,parameter="temperature")
}
}
\keyword{raw}
