% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ProbitRE.R
\name{ProbitRE}
\alias{ProbitRE}
\title{A Probit Model with Random Effects}
\usage{
ProbitRE(formula, id, data = NULL, delta = 1, method = "BFGS",
  lower = NULL, upper = NULL, H = 20, accu = 1e+10, verbose = 0)
}
\arguments{
\item{formula}{Formula of the model}

\item{id}{A vector that represents the identity of individuals, numeric or character}

\item{data}{Input data, a data frame}

\item{delta}{Variance of random effects on the individual level for ProbitRE}

\item{method}{Searching algorithm, don't change default unless you know what you are doing}

\item{lower}{Lower bound for estiamtes}

\item{upper}{Upper bound for estimates}

\item{H}{A vector of length 2, specifying the number of points for inner and outer Quadratures}

\item{accu}{1e12 for low accuracy; 1e7 for moderate accuracy; 10.0 for extremely high accuracy. See optim}

\item{verbose}{Level of output during estimation. Lowest is 0.}
}
\value{
A list containing the results of the estimated model
}
\description{
Estimate a Probit model with random effects
}
\examples{
data(rt)
est = ProbitRE(isRetweet~fans+tweets+as.factor(tweet.id),
                    id=rt$user.id, data=rt)
}
\seealso{
Other PanelCount: \code{\link{CRE_SS}}; \code{\link{CRE}};
  \code{\link{PLN_RE}}; \code{\link{PoissonRE}}
}

