% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanelEstimateObject.R
\name{plot.PanelEstimate}
\alias{plot.PanelEstimate}
\title{Plot point estimates and standard errors from a PanelEstimate calculation.}
\usage{
\method{plot}{PanelEstimate}(
  x,
  ylab = "Estimated Effect of Treatment",
  xlab = "Time",
  main = "Estimated Effects of Treatment Over Time",
  ylim = NULL,
  pch = NULL,
  cex = NULL,
  confidence.level = NULL,
  bias.corrected = FALSE,
  ...
)
}
\arguments{
\item{x}{a \code{PanelEstimate} object}

\item{ylab}{default is "Estimated Effect of Treatment." This is the same argument as the standard argument for \code{plot()}}

\item{xlab}{default is "Time". This is the same argument as the standard argument for \code{plot()}}

\item{main}{default is "Estimated Effects of Treatment Over Time". This is the same argument as the standard argument for \code{plot}}

\item{ylim}{default is NULL. This is the same argument as the standard argument for \code{plot()}}

\item{pch}{default is NULL. This is the same argument as the standard argument for \code{plot()}}

\item{cex}{default is NULL. This is the same argument as the standard argument for \code{plot()}}

\item{confidence.level}{confidence.level Confidence level to be used for confidence interval calculations. Must be numeric between 0 and 1. If NULL, confidence level from \code{PanelEstimate()} specification is used.}

\item{bias.corrected}{logical indicating whether or not bias corrected estimates should be plotted Default is FALSE. This argument only applies for standard errors calculated with the bootstrap.}

\item{...}{Additional optional arguments to be passed to \code{plot()}.}
}
\description{
The \code{plot.PanelEstimate} method takes an object returned by the \code{PanelEstimate} function and plots the calculated 
point estimates and standard errors over the specified \code{lead} time period. 
The only mandatory argument is an object of the \code{PanelEstimate} class.
}
\examples{
dem.sub <- dem[dem[, "wbcode2"] <= 100, ]
dem.sub.panel <- PanelData(dem.sub, "wbcode2", "year", "dem", "y")
# create subset of data for simplicity
PM.results <- PanelMatch(panel.data = dem.sub.panel, lag = 4, 
                         refinement.method = "ps.match", 
                         match.missing = TRUE, 
                         covs.formula = ~ tradewb,
                         size.match = 5, qoi = "att",
                         lead = 0:4, 
                         forbid.treatment.reversal = FALSE)
PE.results <- PanelEstimate(sets = PM.results, 
              panel.data = dem.sub.panel, 
              se.method = "unconditional")
plot(PE.results)

}
