% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Appenders.R
\name{createEmailAppender}
\alias{createEmailAppender}
\title{Create e-mail appender}
\usage{
createEmailAppender(
  layout = layoutEmail,
  mailSettings,
  label = Sys.info()["nodename"],
  test = FALSE
)
}
\arguments{
\item{layout}{The layout to be used by the appender.}

\item{mailSettings}{Arguments to be passed to the send.mail function in the mailR package (except
subject and body).}

\item{label}{A label to be used in the e-mail subject to identify a run. By default the
name of the computer is used.}

\item{test}{If TRUE, a message will be displayed on the console instead of sending an
e-mail.}
}
\description{
Create e-mail appender
}
\details{
Creates an appender that will send log events to an e-mail address using the \code{mailR} package.
Please make sure your settings are correct by using the mailR package before using those settings
here. ParallelLogger will not display any messages if something goes wrong when sending the e-mail.
}
\examples{
mailSettings <- list(
  from = "someone@gmail.com",
  to = c("someone_else@gmail.com"),
  smtp = list(
    host.name = "smtp.gmail.com",
    port = 465,
    user.name = "someone@gmail.com",
    passwd = "super_secret!",
    ssl = TRUE
  ),
  authenticate = TRUE,
  send = TRUE
)
# Setting test to TRUE in this example so we don't really send an e-mail:
appender <- createEmailAppender(
  layout = layoutEmail,
  mailSettings = mailSettings,
  label = "My R session",
  test = TRUE
)

logger <- createLogger(name = "EMAIL", threshold = "FATAL", appenders = list(appender))
registerLogger(logger)

logFatal("Something bad")

unregisterLogger("EMAIL")
}
