% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ParallelPC.R
\name{zf}
\alias{zf}
\title{Gaussian conditional independence test}
\usage{
zf(x, y, S, suffStat)
}
\arguments{
\item{x,y,S}{It is tested, whether x and y are conditionally independent given the subset S of
the remaining nodes. x, y, S all are integers, corresponding to variable or node
numbers.}

\item{suffStat}{the data matrix with rows are samples and columns are the variables.}
}
\value{
The p-value of the test.
}
\description{
Gaussian conditional independence test. See the zf function in the bnlearn package for more details.
}
\examples{
##########################################
## Using zf
##########################################
library(bnlearn)
library(pcalg)
data("gmG")
suffStat<-gmG$x
zf(1,2,3,suffStat)
}
\references{
Marco Scutari (2010). Learning Bayesian Networks with the bnlearn R Package. Journal of Statistical Software, 35(3), 1-22.
}

