% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryMCMCSAR.R
\name{plot.mcmcSAR}
\alias{plot.mcmcSAR}
\alias{print.plot.mcmcSAR}
\title{Plotting estimation of Bayesian SAR model}
\usage{
\method{plot}{mcmcSAR}(x, plot.type = "sim", burnin = NULL, which.parms = "theta", ...)

\method{print}{plot.mcmcSAR}(x, ...)
}
\arguments{
\item{x}{object of class "mcmcSAR", output of the function \code{\link{mcmcSAR}} or object of class "plot.mcmcSAR", output of the function \code{\link{plot.mcmcSAR}}.}

\item{plot.type}{character indicating the type of plot: \code{"sim"} for plotting the simulation
from the posterior distribution or \code{"dens"} for plotting the posterior density functions.}

\item{burnin}{number of MCMC steps which will be considered as burn-in iterations. If \code{NULL} (default value),
the 50\% first MCMC steps performed are used as burn-in iterations.}

\item{which.parms}{character indicating the parameters whose the posterior distribution will be plotted: \code{"theta"} for
the parameters of the outcome model and \code{"rho"} for the parameters of the network formation model.}

\item{...}{arguments to be passed to methods, such as \link[graphics]{par}.}
}
\value{
A list consisting of:
\item{n.group}{number of groups.}
\item{N}{vector of each group size.}
\item{iteration}{number of MCMC steps performed.}
\item{burnin}{number of MCMC steps which will be considered as burn-in iterations.}
\item{posterior}{summary of the posterior distribution to be plotted.}
\item{hyperparms}{return value of \code{hyperparms}.}
\item{accept.rate}{acceptance rate of zeta.}
\item{propG0.obs}{proportion of observed network data.}
\item{method.net}{network formation model specification.}
\item{formula}{input value of \code{formula}.}
\item{ctrl.mcmc}{return value of \code{ctrl.mcmc}.}
\item{which.parms}{return value of \code{which.parms}.}
\item{plot.type}{type of the plot.}
\item{...}{arguments passed to methods.}
}
\description{
Plotting the simulation from the posterior distribution as well as the
density functions of Bayesian SAR model parameter. For more details about the graphical
parameter arguments, see \link[graphics]{par}.
}
