% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simNetwork.R
\name{sim.network}
\alias{sim.network}
\title{Simulating network data}
\usage{
sim.network(dnetwork, normalise = FALSE)
}
\arguments{
\item{dnetwork}{is a list of sub-network matrices, where the (i, j)-th position of the m-th matrix is the probability that i be connected to j, with i and j individuals from the m-th network.}

\item{normalise}{boolean takes \code{TRUE} if the returned matrices should be row-normalized and \code{FALSE} otherwise.}
}
\value{
list of (row-normalized) adjacency matrices.
}
\description{
Simulating network data
}
\examples{
# Generate a list of adjacency matrices
## sub-network size
N         <- c(250, 370, 120)  
## distribution
dnetwork  <- lapply(N, function(x) matrix(runif(x^2), x))
## network
G         <- sim.network(dnetwork)
}
\seealso{
\code{\link{sim.dnetwork}}
}
