% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspaceMethods.R
\docType{methods}
\name{getPathwaySpace,PathwaySpace-method}
\alias{getPathwaySpace,PathwaySpace-method}
\alias{getPathwaySpace}
\title{Accessors for fetching slots from a PathwaySpace object.}
\usage{
\S4method{getPathwaySpace}{PathwaySpace}(pts, what = "status")
}
\arguments{
\item{pts}{A preprocessed \linkS4class{PathwaySpace} class object}

\item{what}{A single character value specifying which information should 
be retrieved from the slots.
Options: 'graph','gxy','gxyz','pars','misc','status','summits',
'summit_mask', and 'summit_contour'.}
}
\value{
Content from slots in the \linkS4class{PathwaySpace} object.
}
\description{
\code{getPathwaySpace} retrives information from
individual slots available in a PathwaySpace object.
}
\examples{
# Load a demo igraph
data('gtoy1', package = 'PathwaySpace')

# Create a new PathwaySpace object
pts <- buildPathwaySpace(gtoy1, nrc = 100)
# note: adjust 'nrc' to increase image resolution

# Get the 'status' slot in pts
status <- getPathwaySpace(pts, what = 'status')

}
