% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiagnosePlp.R
\name{diagnosePlp}
\alias{diagnosePlp}
\title{diagnostic - Investigates the prediction problem settings - use before training a model}
\usage{
diagnosePlp(
  plpData = NULL,
  outcomeId,
  analysisId,
  populationSettings,
  splitSettings = createDefaultSplitSetting(),
  sampleSettings = createSampleSettings(),
  saveDirectory = NULL,
  featureEngineeringSettings = createFeatureEngineeringSettings(),
  modelSettings = setLassoLogisticRegression(),
  logSettings = createLogSettings(verbosity = "DEBUG", timeStamp = TRUE, logName =
    "diagnosePlp Log"),
  preprocessSettings = createPreprocessSettings()
)
}
\arguments{
\item{plpData}{An object of type \code{plpData} - the patient level prediction
data extracted from the CDM.  Can also include an initial population as
plpData$popualtion.}

\item{outcomeId}{(integer) The ID of the outcome.}

\item{analysisId}{(integer) Identifier for the analysis. It is used to create, e.g., the result folder. Default is a timestamp.}

\item{populationSettings}{An object of type \code{populationSettings} created using \code{createStudyPopulationSettings} that
specifies how the data class labels are defined and addition any exclusions to apply to the
plpData cohort}

\item{splitSettings}{An object of type \code{splitSettings} that specifies how to split the data into train/validation/test.
The default settings can be created using \code{createDefaultSplitSetting}.}

\item{sampleSettings}{An object of type \code{sampleSettings} that specifies any under/over sampling to be done.
The default is none.}

\item{saveDirectory}{The path to the directory where the results will be saved (if NULL uses working directory)}

\item{featureEngineeringSettings}{An object of \code{featureEngineeringSettings} specifying any feature engineering to be learned (using the train data)}

\item{modelSettings}{An object of class \code{modelSettings} created using one of the function:
\itemize{
\item setLassoLogisticRegression() A lasso logistic regression model
\item setGradientBoostingMachine() A gradient boosting machine
\item setAdaBoost() An ada boost model
\item setRandomForest() A random forest model
\item setDecisionTree() A decision tree model
}}

\item{logSettings}{An object of \code{logSettings} created using \code{createLogSettings}
specifying how the logging is done}

\item{preprocessSettings}{An object of \code{preprocessSettings}. This setting specifies the minimum fraction of
target population who must have a covariate for it to be included in the model training
and whether to normalise the covariates before training}
}
\value{
An object containing the model or location where the model is saved, the data selection settings, the preprocessing
and training settings as well as various performance measures obtained by the model.
\itemize{
\item{\code{distribution}: List for each O of a data.frame containing: i) Time to observation end distribution, ii) Time from observation start distribution, iii) Time to event distribution and iv) Time from last prior event to index distribution (only for patients in T who have O before index) }
\item{\code{incident}: List for each O of incidence of O in T during TAR}
\item{\code{characterization}: List for each O of Characterization of T, TnO, Tn~O}
}
}
\description{
This function runs a set of prediction diagnoses to help pick a suitable T, O, TAR and determine
whether the prediction problem is worth executing.
}
\details{
Users can define set of Ts, Os, databases and population settings.  A list of data.frames containing details such as
follow-up time distribution, time-to-event information, characteriszation details, time from last prior event,
observation time distribution.
}
\examples{
\dontshow{if (rlang::is_installed("Eunomia") && rlang::is_installed("curl") && curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{ \dontshow{ # takes too long }

# load the data
plpData <- getEunomiaPlpData()
populationSettings <- createStudyPopulationSettings(minTimeAtRisk = 1)
saveDirectory <- file.path(tempdir(), "diagnosePlp")
diagnosis <- diagnosePlp(plpData = plpData, outcomeId = 3, analysisId = 1, 
     populationSettings = populationSettings, saveDirectory = saveDirectory)
# clean up
unlink(saveDirectory, recursive = TRUE)
}
\dontshow{\}) # examplesIf}
}
