% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micro_array.R, R/network.R, R/micropredict.R
\docType{methods}
\name{plot-methods}
\alias{plot-methods}
\alias{plot,micro_array,ANY-method}
\alias{plot,micropredict,ANY-method}
\alias{plot,network,ANY-method}
\title{Plot}
\usage{
\S4method{plot}{micro_array,ANY}(x, y, ...)

\S4method{plot}{network,ANY}(
  x,
  y,
  choice = "network",
  nv = 0,
  gr = NULL,
  ini = NULL,
  color.vertex = NULL,
  color.edge = NULL,
  video = TRUE,
  weight.node = NULL,
  ani = FALSE,
  size = c(2000, 1000),
  label_v = 1:dim(x@network)[1],
  horiz = TRUE,
  legend.position = "topleft",
  frame.color = "black",
  label.hub = FALSE,
  nround = 2,
  ani.img.name = "Rplot",
  ani.imgdir = "images",
  ani.htmlfile = "index.html",
  outdir,
  ani.group.legend = "Cluster",
  layout = ini,
  alpha = 1,
  pixmap.color = terrain.colors(20),
  ...
)

\S4method{plot}{micropredict,ANY}(
  x,
  time = NULL,
  label_v = NULL,
  frame.color = "white",
  ini = NULL,
  label.hub = FALSE,
  edge.arrow.size = 0.7,
  edge.thickness = 1
)
}
\arguments{
\item{x}{a micro\_array object, a network object or a micropredict object}

\item{y}{optional and not used if x is an appropriate structure}

\item{...}{additional parameters}

\item{choice}{what graphic should be plotted: either "F"
(for a representation of the matrices F) or "network".}

\item{nv}{the level of cutoff. Defaut to `0`.}

\item{gr}{a vector giving the group of each gene}

\item{ini}{using the ``position'' function, you can
fix the position of the nodes.}

\item{color.vertex}{a vector defining the color of the vertex.}

\item{color.edge}{color of the edges}

\item{video}{if ani is TRUE and video is TRUE, the result of the animation is saved as an animated GIF.}

\item{weight.node}{nodes weighting. Defaults to `NULL`.}

\item{ani}{animated plot?}

\item{size}{vector giving the size of the plot. Default to `c(2000,1000)`.}

\item{label_v}{vector defining the vertex labels.}

\item{horiz}{landscape? Defaults to `TRUE`.}

\item{legend.position}{position of the legend.}

\item{frame.color}{color of the frames.}

\item{label.hub}{logical ; if TRUE only the hubs are labeled.}

\item{nround}{number of digits to display}

\item{ani.img.name}{name of image file  for animations}

\item{ani.imgdir}{name of the image directory for animations}

\item{ani.htmlfile}{name of the html file for animations}

\item{outdir}{name of the outdir for animations}

\item{ani.group.legend}{legend for animations}

\item{layout}{layout of the graphs}

\item{alpha}{transparency of the graphs}

\item{pixmap.color}{color for pixmap graphs}

\item{time}{sets the time for plot of the prediction. Defaults to `NULL`}

\item{edge.arrow.size}{size of the arrows ; default to 0.7.}

\item{edge.thickness}{edge thickness ; default to 1.}
}
\description{
Considering the class of the argument which is passed to plot, the graphical
output differs.
}
\section{Methods}{
 \describe{

\item{list("signature(x = \"micro_array\", y = \"ANY\",...)")}{ \describe{
\item{x}{a micro\_array object} \item{list_nv}{a vector of cutoff at which
the network should be shown} } } \item{list("signature(x = \"network\", y =
\"ANY\",...)")}{ \describe{ \item{x}{a network object}
\item{list()}{Optionnal arguments: \describe{ \item{gr}{a vector giving the
group of each gene} \item{choice}{what graphic should be plotted: either "F"
(for a representation of the matrices F) or "network".} \item{nv}{the level
of cutoff. Defaut to 0.} \item{ini}{using the ``position'' function, you can
fix the position of the nodes} \item{color.vertex}{a vector defining the
color of the vertex} \item{ani}{vector giving the size of the plot. Default
to c(2000,1000). The animation can only be created in the working directory.
See the help page of the animation method.} \item{video}{if ani is TRUE and
video is TRUE, the animation result is a GIF video} \item{label_v}{vector
defining the vertex labels} \item{legend.position}{position of the legend}
\item{frame.color}{color of the frames} \item{label.hub}{logical ; if TRUE
only the hubs are labeled} \item{edge.arrow.size}{size of the arrows ;
default to 0.7} \item{edge.thickness}{edge thickness ; default to 1.} } }}}

\item{list("signature(x = \"micropredict\", y = \"ANY\",...)")}{ \describe{
\item{x}{a micropredict object} \item{list()}{Optionnal arguments: see plot
for network} }} }
}

\examples{

if(require(CascadeData)){
data(micro_US, package="CascadeData")
micro_US<-as.micro_array(micro_US[1:100,],time=c(60,90,210,390),subject=6)
plot(micro_US)
}

}
\author{
Bertrand Frederic, Myriam Maumy-Bertrand.
}
\keyword{methods}
