% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/summarizeGeneExpression.R
\name{summarizeGeneExpression}
\alias{summarizeGeneExpression}
\title{Takes the gene expression RNA data from a PharmacoSet, and summarises them
into one entry per drug}
\usage{
summarizeGeneExpression(pSet, cells, summaryStat = "median",
  fillMissing = TRUE, verbose = TRUE)
}
\arguments{
\item{pSet}{\code{PharmacoSet} The PharmacoSet to summarize}

\item{cells}{\code{character} The cell lines to be summarized in the
resulting PharmacoSet. If any cells have no data, they will be filled with
missing values}

\item{summaryStat}{\code{character} which summary method to use if there are repeated
cells?}

\item{fillMissing}{\code{boolean} should the missing cell lines not in the
expression object be filled in with missing values?}

\item{verbose}{\code{bool} Should the function report progress?}
}
\value{
\code{matrix} An updated PharmacoSet with the RNA expression summarized
  per cell line.
}
\description{
Given a PharmacoSet with RNA expression data, this function will summarize
the data into one profile per cell line, using the chosed summaryStat. Note
that this does not really make sense with perturbation type data, and will
combine experiments and controls when doing the summary if run on a
perturbation dataset.
}
\examples{
data(CGPsmall)
CGPsmall <- summarizeGeneExpression(CGPsmall, cells=cellNames(CGPsmall),
                    summaryStat = 'median', fillMissing = TRUE, verbose=TRUE)
CGPsmall
}

