% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{RunAdaptiveEffToxTrial}
\alias{RunAdaptiveEffToxTrial}
\title{Simulates repitions of an Adaptive Eff-Tox Trial.}
\usage{
RunAdaptiveEffToxTrial(DoseStart, Dose, Hypermeans, Hypervars, Contour, PiLim,
  ProbLim, cohort, NET, NF, B, nSims, PETrue, PTTrue)
}
\arguments{
\item{DoseStart}{Dose to start enrolling cohorts of patients at.}

\item{Dose}{Vector containing the standardized doses considered.}

\item{Hypermeans}{Vector containing prior hypermeans of length 6 for Eff-Tox parameters.}

\item{Hypervars}{Vector containing prior hypervariances of length 6 for Eff-Tox parameters.}

\item{Contour}{Vector containing 4 entries used to make the desireability function. Contour[1] contains a desired toxicity probability given efficacy, Countour[2] contains a desired efficacy probability given toxicity, and (Contour[3],Contour[4]) is an equally desireable pair of efficacy and toxicity probabilities that are non-zero or one.}

\item{PiLim}{Vector of length two with PiLim[1] containing the acceptable lower limit on efficacy probability and PiLim[2] containing the acceptable upper limit on toxicity probability.}

\item{ProbLim}{Vector of length two with ProbLim[1] containing the probability cutoff for acceptable efficacy probability and ProbLim[2] containing the probability cutoff for acceptable toxicity probability.}

\item{cohort}{Size of each patient cohort.}

\item{NET}{Maximum sample size for phase I/II.}

\item{NF}{Number of patients to assign optimal doses prior to adaptive randomization.}

\item{B}{Number of iterations to perform in the MCMC.}

\item{nSims}{Number of simulated trials to run.}

\item{PETrue}{True vector of efficacy probabilities for each dose.}

\item{PTTrue}{True vector of toxicity probabilities for each dose.}
}
\value{
List containing the vector of optimal doses chosen, a matrix of posterior desireability scores for each trial, and a matrix consisting of patient dose assignments and Toxicity and Efficacy indicators, with each Nmax rows corresponding to a separate trial. Trials that are stopped due to excessive toxicity probabilty or small efficacy probabilities are not included in the final results.
}
\description{
This function simulates repititions of an adaptive Eff-Tox Trial and returns a list containing the optimal dose chosen
}
\examples{
##Doses, YE,YT
##Starting Dose
DoseStart=1
##Vector of Numerical Doses
Dose = c(1,2,3,3.5,5)
Dose=(Dose-mean(Dose))/sd(Dose)
## Contour Vector
Contour = c(.35, .75,.7,.4)
##Hypermeans
Hypermeans = c(.022,3.45,0,-4.23,3.1,0)
Hypervars = c(2.6761, 2.6852, .2, 3.1304, 3.1165, 1)
Hypervars=Hypervars^2
##Acceptability Criteria
PiLim = c(.3,.4)
ProbLim=c(.1,.1)
##Cohort Size, N^F and N_ET
cohort=3
NF=15
NET=30
PTTrue = c(.1,.15,.25,.35,.5)
PETrue=c(.2,.4,.6,.65,.7)
##Number of iterations for MCMC
B=2000
### Number of Simulations
nSims=1
RunAdaptiveEffToxTrial(DoseStart,Dose, Hypermeans,  Hypervars,
Contour, PiLim, ProbLim,  cohort, NET,  NF, B, nSims, PETrue, PTTrue )
}
