% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_EM.R
\name{init.alpha.gamma.estimation}
\alias{init.alpha.gamma.estimation}
\title{Initialization the selection strength alpha using robust estimation}
\usage{
init.alpha.gamma.estimation(phylo, Y_data, nbr_of_shifts, times_shared,
  distances_phylo, T_tree, subtree.list, max_triplet_number, alpha_known,
  method.init.alpha.estimation, tol, h_tree, miss, masque_data, independent,
  ...)
}
\arguments{
\item{phylo}{a phylogenetic tree, class \code{\link[ape]{phylo}}.}

\item{Y_data}{data at the tips.}

\item{nbr_of_shifts}{: number of shifts wanted}

\item{distances_phylo}{(matrix) : phylogenetic distance, result of function 
\code{compute_dist_phy}}

\item{nbr_of_shifts}{number of shifts used in the EM algorithm}
}
\value{
params_init the list of initial parameters to be used, in the right
 format.
}
\description{
\code{init.alpha.estimation} fits (Y_i-Y_j)^2 ~ gamma^2(1-exp(-alpha*d_ij))
for all couples of tips (i,j) that have the same mean, i.e than are not
separated by a shift. Shifts are initialized thanks to a lasso
(function \code{init.EM.lasso}).
}
\details{
Function \code{robustbase::nlrob} is used for the robust fit.
}
\keyword{internal}
