% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readCountsData.R
\name{readCountsData}
\alias{readCountsData}
\title{Convert Accelerometer Output Data to a Correct Data Format}
\usage{
readCountsData(filename, ctPerSec, mode = 0)
}
\arguments{
\item{filename}{A filename of accelerometer output to be read.}

\item{ctPerSec}{Data collection epoch. This argument tells the program the
number of counting will be performed in every second. For examples: for 1-sec
epoch data, set ctPerSec = 1; for 10-sec epoch data, set ctPerSec = 1/10; for
1-min epoch data, set ctPerSec = 1/60.}

\item{mode}{The mode of the ActiLife dat file.  Defaults to 0, and should be
listed in the file header.}
}
\value{
a data frame with the correct format (TimeStamp, counts) to be used for
\code{\link{wearingMarking}}.
}
\description{
This function converts accelerometer output data to a correct data format to
classify wear and nonwear time using \code{\link{wearingMarking}}. This
function can accept accelerometer output data with various epochs (for
example, 1-sec, 10-sec or 1-min). If accelerometer data are collected with 
three axes, it creates vector magnitude (vm).
}
\note{
Warning: It can be very slow if accelerometer data were collected with
1-sec epoch for many days.
}
\examples{
###############################################################################
## Read accelerometer output and convert to a correct format (TimeStamp, counts)
## Suppose "rawActigraphOutput.dat" is an Actigraph output with header as follows:
###############################################################################
## --- Data File Created By ActiGraph GT1M ActiLife v4.4.1 Firmware v7.2.0 ---
## Serial Number: LYN2B21080027
## Start Time 16:15:00
## Start Date 6/16/2010
## Epoch Period (hh:mm:ss) 00:00:01
## Download Time 09:50:23
## Download Date 6/22/2010
## Current Memory Address: 983038
## Current Battery Voltage: 4.01     Mode = 0
## --------------------------------------------------
###############################################################################
## This raw data with 1-sec epoch can be converted to a correct data format to
## classify wear and nonwear time using "wearingMarking" by the following code:

\dontrun{mydata1s = readCountsData("rawActigraphOutput.dat", ctPerSec=1)}
}
\references{
Choi L, Liu Z, Matthews CE, Buchowski MS. 
Validation of accelerometer wear and nonwear time classification algorithm.
Med Sci Sports Exerc. 2011 Feb;43(2):357-64.
}
\seealso{
\code{\link{wearingMarking}}
}
\author{
Zhouwen Liu \email{zhouwen.liu@vumc.org}
}
