% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spatial_cluster.R
\name{Spatial_cluster}
\alias{Spatial_cluster}
\title{Plotting clusters of cells by choosing between 10X Genomics clustering or reclustering the cells.}
\usage{
Spatial_cluster(
  cluster = c("GEX_cluster", "reclustering"),
  GEX.out.directory.list,
  vgm_VDJ,
  vgm_cluster,
  sample_names,
  bcs_merge,
  images_tibble,
  title,
  size,
  legend_title
)
}
\arguments{
\item{cluster}{Character vector to describe the clustering, "GEX_cluster" is for plotting 10X Genomics clustering and "reclustering" is for reclustering the cells according to the given subset.}

\item{GEX.out.directory.list}{Character vector that give the path to filtered_feature_bc_matrix data.}

\item{vgm_VDJ}{Data frame containing cell of interest and x and y coordinates and GEX_barcode.}

\item{vgm_cluster}{Data frame containing GEX barcode and cluster given by 10X Genomics. Only needed if cluster parameter is set to "GEX_cluster".}

\item{sample_names}{Character vector containing the name of the sample.}

\item{bcs_merge}{Data frame containing imagerow, imagecol and barcode of the cells belonging to the spatial image. It can also be created by the function scaling_spatial_image_parameter by selecting the output parameter 10.}

\item{images_tibble}{Tbl-df containing the sample name, grob, height and width of the spatial image. It can also be created by the function scaling_spatial_image_parameter by selecting the output parameter 5.}

\item{title}{Character vector to name the plot.}

\item{size}{Number, to define the size of the text, default = 15.}

\item{legend_title}{Character vector to name the legend scale.}
}
\value{
If plotting = TRUE, returns a list containing [[1]] the plot of the selected cells according to their group, [[2]] a data frame that contains the column seurat_clusters with the new cluster. If plotting = FALSE, it returns just the data frame.
}
\description{
Plotting clusters of cells by choosing between 10X Genomics clustering or reclustering the cells.
}
\examples{
\dontrun{
#Clustering of whole cells regardless of cell type
GEX_cluster_B_cells<-Spatial_cluster(cluster = "GEX_cluster",
vgm_cluster = vgm_with_simulated_VDJ$spatial$cluster[[1]],
vgm_VDJ = vgm_with_simulated_VDJ$VDJ,
GEX.out.directory.list = GEX.out.directory.list[[1]],images_tibble=scaling_parameters[[5]],
bcs_merge=scaling_parameters[[10]], title = "B cells",
sample_names = sample_names, legend_title = "GEX clusters" )
GEX_cluster_B_cells[[1]]

#Reclustering with only B cells
reclustering_B_cells<-Spatial_cluster(cluster = "reclustering",
vgm_VDJ = vgm_with_simulated_VDJ$VDJ,
GEX.out.directory.list = GEX.out.directory.list[[1]],
images_tibble=scaling_parameters[[5]],bcs_merge=scaling_parameters[[10]],
title = "B cells", sample_names = sample_names, legend_title = "Reclustering")
reclustering_B_cells[[1]]
}
}
