% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{read.ShesisPlus.output}
\alias{read.ShesisPlus.output}
\title{Read the haplotyping results from the ShesisPlus output}
\usage{
read.ShesisPlus.output(SSPout, order.by=c("", "hapnr", "count")[2])
}
\arguments{
\item{SSPout}{filename of a text file with ShesisPlus output (as copied from
the web page produced by running ShesisPlus web interface
at http://shesisplus.bio-x.cn/SHEsis.html); or a character vector with the
same output}

\item{order.by}{how to order the rows of the hapstat data.frame. "hapnr" means
ordering by haplotype number, "count" means ordering by decreasing Total.count,
anything else results in no reordering. By default order by hapnr.}
}
\value{
a list with 2 items: $markernames has the marker names in the markers in
the haploblock (if present in the file); hapstat contains the haplotype statistics
as read from the file with an additional (first) column hapnr: the haplotype
numbers as defined in PolyHaplotyper. The other columns are Haplotype (as sequences
of marker alleles), Total.count (of the haplotype over the whole population) and,
according to an email from Zhiqiang Li of 13-04-2020) BETA: Regression coefficient,
SE: Standard error, R2: Regression r-squared, T: t-distribution statistics,
P: p-value
}
\description{
Read the haplotyping results from the ShesisPlus output
}
\details{
If present, the markernames and the haplotype statistics are read from
the file. ShesisPlus does not provide haplotype combinations for individuals
}
\examples{
# we give a typical SSP output as character vector; instead we could also
# give the name of a text file
SSPout <- c(
 " Please cite:",
 "",
 "    Shen, J. et al. SHEsisPlus, a toolset for genetic studies ...",
 "    Shi, Y. et al. SHEsis, a powerful software platform ...",
 "    Li, Z. et al. A partition-ligation-combination-subdivision ...",
 "",
 "if you find this tool useful in your research. Thanks!",
 "",
 "Haplotype Analysis:",
 "",
 "Haplotypes with frequency <0.03 are ignored.",
 "Loci chosen for haplotype analysis: m1, m2, m3, m4",
 "Haplotype 	Total count 	Beta 	SE 	R2 	T 	p",
 "1122 	2232 	0.002 	0.01 	1.01e-04 	0.252 	0.8",
 "1222 	230 	-0.019 	0.017 	0.002 	-1.15 	0.25",
 "1221 	152 	-0.01 	0.024 	2.94e-04 	-0.43 	0.667",
 "2222 	288 	0.008 	0.02 	2.93e-04 	0.429 	0.667",
 "1121 	142 	-0.009 	0.022 	2.81e-04 	-0.42 	0.674"
)
read.ShesisPlus.output(SSPout)
}
