% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_filter_lr.R
\name{filter_lr_all}
\alias{filter_lr_all}
\title{Filter and Analyze Ligand-Receptor Pair Correlations (All Cell Types)}
\usage{
filter_lr_all(
  rna,
  lr_database = PopComm::lr_db,
  sample_col,
  cell_type_col,
  min_cells = 50,
  min_samples = 10,
  min_cell_ratio = 0.1,
  min_sample_ratio = 0.1,
  cor_method = "spearman",
  adjust_method = "BH",
  min_adjust_p = 0.05,
  min_cor = 0,
  num_cores = 10,
  verbose = TRUE
)
}
\arguments{
\item{rna}{A Seurat object containing single-cell RNA expression data.}

\item{lr_database}{A data frame of ligand-receptor pairs with columns "ligand_gene_symbol" and "receptor_gene_symbol".}

\item{sample_col}{Column name in Seurat metadata indicating sample identifiers (character).}

\item{cell_type_col}{Column name in Seurat metadata indicating cell type classifications (character).}

\item{min_cells}{Minimum cells required per sample for both sender and receiver (numeric, default 50).}

\item{min_samples}{Minimum valid samples required to proceed (numeric, default 10).}

\item{min_cell_ratio}{Minimum ratio of cells expressing ligand and receptor genes in sender or receiver cells (numeric, default 0.1).}

\item{min_sample_ratio}{Minimum ratio of samples in which both the ligand and receptor genes must be expressed (numeric, default 0.1).}

\item{cor_method}{Correlation method: "spearman" (default), "pearson", or "kendall".}

\item{adjust_method}{P-value adjustment method (default "BH" for Benjamini-Hochberg).
Options: "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none".}

\item{min_adjust_p}{Adjusted p-value threshold for significance (numeric, default 0.05).}

\item{min_cor}{Minimum correlation coefficient threshold (numeric, default 0). Must be \eqn{\ge}{>=} 0.}

\item{num_cores}{Number of CPU cores for parallel processing (numeric, default 10). Automatically capped at (system cores - 1).}

\item{verbose}{Logical indicating whether to print progress messages (logical, default: TRUE).}
}
\value{
A data frame includes LR pairs with sufficient correlation and expression support across samples.
\item{ligand, receptor}{Ligand and receptor gene symbols.}
\item{cor}{Correlation coefficient.}
\item{p_val}{Raw p-value.}
\item{adjust.p}{Adjusted p-value.}
\item{sender, receiver}{Sender and receiver cell types.}
\item{slope}{Slope of the linear regression model.}
\item{intercept}{Intercept of the linear regression model.}
Rows are ordered by ascending \code{adjust.p} and descending \code{cor}.

Returns \code{NULL} if:
\itemize{
\item No cell types are found in the metadata.
\item Insufficient samples or cells remain after filtering.
\item No ligand-receptor pairs pass the filtering thresholds.
}
}
\description{
Filters ligand-receptor (LR) pairs and analyzes their correlations for all possible cell type pairs,
and returns significant LR pairs based on user-defined thresholds.
}
\examples{
\donttest{
  # Long-running example (may take >10s)
  seurat_object <- load_example_seurat()
  data(lr_db)

  # Analyzing ligand-receptor interactions between all cell types
  result01a <- filter_lr_all(
    rna = seurat_object,
    lr_database = lr_db,
    sample_col = "sample",
    cell_type_col = "cell.type",
    min_cells = 20,
    min_samples = 10,
    min_adjust_p = 0.5,
    num_cores = 1,
    verbose = TRUE
  )

  if (!is.null(result01a)) {
  print(head(result01a))
  }
}
}
