% Generated by roxygen2 (4.0.1): do not edit by hand
\name{group_constraint}
\alias{group_constraint}
\title{constructor for group_constraint}
\usage{
group_constraint(type = "group", assets, groups, group_labels = NULL,
  group_min, group_max, group_pos = NULL, enabled = TRUE, message = FALSE,
  ...)
}
\arguments{
\item{type}{character type of the constraint}

\item{assets}{number of assets, or optionally a named vector of assets specifying initial weights}

\item{groups}{list of vectors specifying the groups of the assets}

\item{group_labels}{character vector to label the groups (e.g. size, asset class, style, etc.)}

\item{group_min}{numeric or vector specifying minimum weight group constraints}

\item{group_max}{numeric or vector specifying minimum weight group constraints}

\item{group_pos}{vector specifying the number of non-zero weights per group}

\item{enabled}{TRUE/FALSE}

\item{message}{TRUE/FALSE. The default is message=FALSE. Display messages if TRUE.}

\item{\dots}{any other passthru parameters to specify group constraints}
}
\value{
an object of class 'group_constraint'
}
\description{
Group constraints specify the grouping of the assets, weights of the groups, and number of postions (i.e. non-zero weights) iof the groups.
This function is called by add.constraint when type="group" is specified. see \code{\link{add.constraint}}
}
\examples{
data(edhec)
ret <- edhec[, 1:4]

pspec <- portfolio.spec(assets=colnames(ret))

# Assets 1 and 3 are groupA
# Assets 2 and 4 are groupB
pspec <- add.constraint(portfolio=pspec,
                        type="group",
                        groups=list(groupA=c(1, 3),
                                    groupB=c(2, 4)),
                        group_min=c(0.15, 0.25),
                        group_max=c(0.65, 0.55))

# 2 levels of grouping (e.g. by sector and geography)
pspec <- portfolio.spec(assets=5)
# Assets 1, 3, and 5 are Tech
# Assets 2 and 4 are Oil
# Assets 2, 4, and 5 are UK
# Assets 1 and are are US
group_list <- list(group1=c(1, 3, 5),
                   group2=c(2, 4),
                   groupA=c(2, 4, 5),
                   groupB=c(1, 3))

pspec <- add.constraint(portfolio=pspec,
                        type="group",
                        groups=group_list,
                        group_min=c(0.15, 0.25, 0.2, 0.1),
                        group_max=c(0.65, 0.55, 0.5, 0.4))
}
\author{
Ross Bennett
}
\seealso{
\code{\link{add.constraint}}
}

