/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.loader;

import org.openfast.QName;
import org.openfast.template.Field;
import org.openfast.template.MessageTemplate;
import org.openfast.template.loader.GroupParser;
import org.openfast.template.loader.ParsingContext;
import org.openfast.template.loader.UnresolvedStaticTemplateReferenceException;
import org.w3c.dom.Element;

public class TemplateParser
extends GroupParser {
    private boolean loadTemplateIdFromAuxId;

    public TemplateParser(boolean loadTemplateIdFromAuxId) {
        this.loadTemplateIdFromAuxId = loadTemplateIdFromAuxId;
    }

    protected Field parse(Element templateElement, boolean optional, ParsingContext context) {
        QName templateName = this.getTemplateName(templateElement, context);
        try {
            Field[] fields = TemplateParser.parseFields(templateElement, context);
            return this.createMessageTemplate(templateElement, context, templateName, fields);
        }
        catch (UnresolvedStaticTemplateReferenceException e) {
            return null;
        }
    }

    private MessageTemplate createMessageTemplate(Element templateElement, ParsingContext context, QName templateName, Field[] fields) {
        MessageTemplate messageTemplate = new MessageTemplate(templateName, fields);
        TemplateParser.parseMore(templateElement, messageTemplate, context);
        if (this.loadTemplateIdFromAuxId && templateElement.hasAttribute("id")) {
            try {
                int templateId = Integer.parseInt(templateElement.getAttribute("id"));
                context.getTemplateRegistry().register(templateId, messageTemplate);
            }
            catch (NumberFormatException e) {
                context.getTemplateRegistry().define(messageTemplate);
            }
        } else {
            context.getTemplateRegistry().define(messageTemplate);
        }
        return messageTemplate;
    }

    private QName getTemplateName(Element templateElement, ParsingContext context) {
        return new QName(templateElement.getAttribute("name"), context.getTemplateNamespace());
    }
}

