/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.session;

import org.openfast.session.Connection;
import org.openfast.session.Endpoint;
import org.openfast.session.FastConnectionException;
import org.openfast.session.MessageListener;
import org.openfast.session.Session;
import org.openfast.session.SessionListener;
import org.openfast.session.SessionProtocol;
import org.openfast.template.BasicTemplateRegistry;
import org.openfast.template.TemplateRegistry;

public class FastClient {
    private final String clientName;
    private final Endpoint endpoint;
    private final SessionProtocol sessionProtocol;
    private TemplateRegistry inboundRegistry = new BasicTemplateRegistry();
    private TemplateRegistry outboundRegistry = new BasicTemplateRegistry();
    private MessageListener messageListener = MessageListener.NULL;
    private SessionListener sessionListener = SessionListener.NULL;

    public FastClient(String clientName, SessionProtocol sessionProtocol, Endpoint endpoint) {
        this.clientName = clientName;
        this.sessionProtocol = sessionProtocol;
        this.endpoint = endpoint;
    }

    public FastClient(String clientName, SessionProtocol sessionProtocol, Endpoint endpoint, SessionListener sessionListener) {
        this(clientName, sessionProtocol, endpoint);
        this.sessionListener = sessionListener;
    }

    public void setInboundTemplateRegistry(TemplateRegistry registry) {
        this.inboundRegistry = registry;
    }

    public TemplateRegistry getInboundTemplateRegistry() {
        return this.inboundRegistry;
    }

    public void setOutboundTemplateRegistry(TemplateRegistry registry) {
        this.outboundRegistry = registry;
    }

    public TemplateRegistry getOutboundTemplateRegistry() {
        return this.outboundRegistry;
    }

    public Session connect() throws FastConnectionException {
        Connection connection = this.endpoint.connect();
        Session session = this.sessionProtocol.connect(this.clientName, connection, this.inboundRegistry, this.outboundRegistry, this.messageListener, this.sessionListener);
        return session;
    }

    public void setMessageHandler(MessageListener messageListener) {
        this.messageListener = messageListener;
    }
}

