% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml.R
\name{cv_tune_seq}
\alias{cv_tune_seq}
\title{Purged/embargoed K-fold CV for sequence models (inside IS window)}
\usage{
cv_tune_seq(
  features_list,
  labels,
  is_start,
  is_end,
  steps_grid = c(12L, 26L, 52L),
  horizon = 4L,
  fit_fn,
  predict_fn,
  k = 3L,
  purge = NULL,
  embargo = NULL,
  group = c("pooled"),
  max_train_samples = NULL,
  max_val_samples = NULL,
  na_action = c("omit", "zero"),
  metric = c("spearman", "rmse")
)
}
\arguments{
\item{features_list}{List of feature panels (Date + symbols) for sequences.}

\item{labels}{Label panel aligned to features (Date + symbols).}

\item{is_start, is_end}{Inclusive IS window indices (on aligned dates).}

\item{steps_grid}{Integer vector of candidate sequence lengths.}

\item{horizon}{Forecast horizon (periods ahead).}

\item{fit_fn}{Function (X, y) -> model for sequences.}

\item{predict_fn}{Function (model, Xnew) -> numeric scores.}

\item{k}{Number of CV folds.}

\item{purge}{Gap (obs) removed between train/val within folds (default uses steps).}

\item{embargo}{Embargo (obs) after validation to avoid bleed (default uses horizon).}

\item{group}{'pooled', 'per_symbol', or 'per_group'.}

\item{max_train_samples}{Optional cap on IS samples per fold.}

\item{max_val_samples}{Optional cap on validation samples per fold.}

\item{na_action}{How to handle NA features ('omit' or 'zero').}

\item{metric}{IC metric ('spearman' or 'pearson').}
}
\value{
data.table with columns like \code{steps}, \code{folds}, and CV \code{score}.
}
\description{
Purged/embargoed K-fold CV for sequence models (inside IS window)
}
